/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.ListReceivedDataGrantsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListReceivedDataGrantsResponse;
import software.amazon.awssdk.services.dataexchange.model.ReceivedDataGrantSummariesEntry;

public class ListReceivedDataGrantsPublisher
implements SdkPublisher<ListReceivedDataGrantsResponse> {
    private final DataExchangeAsyncClient client;
    private final ListReceivedDataGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReceivedDataGrantsPublisher(DataExchangeAsyncClient client, ListReceivedDataGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReceivedDataGrantsPublisher(DataExchangeAsyncClient client, ListReceivedDataGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReceivedDataGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReceivedDataGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReceivedDataGrantSummariesEntry> dataGrantSummaries() {
        Function<ListReceivedDataGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataGrantSummaries() != null) {
                return response.dataGrantSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReceivedDataGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReceivedDataGrantsResponseFetcher
    implements AsyncPageFetcher<ListReceivedDataGrantsResponse> {
        private ListReceivedDataGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListReceivedDataGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReceivedDataGrantsResponse> nextPage(ListReceivedDataGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListReceivedDataGrantsPublisher.this.client.listReceivedDataGrants(ListReceivedDataGrantsPublisher.this.firstRequest);
            }
            return ListReceivedDataGrantsPublisher.this.client.listReceivedDataGrants((ListReceivedDataGrantsRequest)((Object)ListReceivedDataGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

