/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.ListOfReceivedDataGrantSummariesEntryCopier;
import software.amazon.awssdk.services.dataexchange.model.ReceivedDataGrantSummariesEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReceivedDataGrantsResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, ListReceivedDataGrantsResponse> {
    private static final SdkField<List<ReceivedDataGrantSummariesEntry>> DATA_GRANT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataGrantSummaries").getter(ListReceivedDataGrantsResponse.getter(ListReceivedDataGrantsResponse::dataGrantSummaries)).setter(ListReceivedDataGrantsResponse.setter(Builder::dataGrantSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataGrantSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReceivedDataGrantSummariesEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReceivedDataGrantsResponse.getter(ListReceivedDataGrantsResponse::nextToken)).setter(ListReceivedDataGrantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_GRANT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReceivedDataGrantsResponse.memberNameToFieldInitializer();
    private final List<ReceivedDataGrantSummariesEntry> dataGrantSummaries;
    private final String nextToken;

    private ListReceivedDataGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.dataGrantSummaries = builder.dataGrantSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataGrantSummaries() {
        return this.dataGrantSummaries != null && !(this.dataGrantSummaries instanceof SdkAutoConstructList);
    }

    public final List<ReceivedDataGrantSummariesEntry> dataGrantSummaries() {
        return this.dataGrantSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataGrantSummaries() ? this.dataGrantSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceivedDataGrantsResponse)) {
            return false;
        }
        ListReceivedDataGrantsResponse other = (ListReceivedDataGrantsResponse)((Object)obj);
        return this.hasDataGrantSummaries() == other.hasDataGrantSummaries() && Objects.equals(this.dataGrantSummaries(), other.dataGrantSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReceivedDataGrantsResponse").add("DataGrantSummaries", this.hasDataGrantSummaries() ? this.dataGrantSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataGrantSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataGrantSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataGrantSummaries", DATA_GRANT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReceivedDataGrantsResponse, T> g) {
        return obj -> g.apply((ListReceivedDataGrantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private List<ReceivedDataGrantSummariesEntry> dataGrantSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceivedDataGrantsResponse model) {
            super(model);
            this.dataGrantSummaries(model.dataGrantSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ReceivedDataGrantSummariesEntry.Builder> getDataGrantSummaries() {
            List<ReceivedDataGrantSummariesEntry.Builder> result = ListOfReceivedDataGrantSummariesEntryCopier.copyToBuilder(this.dataGrantSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataGrantSummaries(Collection<ReceivedDataGrantSummariesEntry.BuilderImpl> dataGrantSummaries) {
            this.dataGrantSummaries = ListOfReceivedDataGrantSummariesEntryCopier.copyFromBuilder(dataGrantSummaries);
        }

        @Override
        public final Builder dataGrantSummaries(Collection<ReceivedDataGrantSummariesEntry> dataGrantSummaries) {
            this.dataGrantSummaries = ListOfReceivedDataGrantSummariesEntryCopier.copy(dataGrantSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataGrantSummaries(ReceivedDataGrantSummariesEntry ... dataGrantSummaries) {
            this.dataGrantSummaries(Arrays.asList(dataGrantSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataGrantSummaries(Consumer<ReceivedDataGrantSummariesEntry.Builder> ... dataGrantSummaries) {
            this.dataGrantSummaries(Stream.of(dataGrantSummaries).map(c -> (ReceivedDataGrantSummariesEntry)((ReceivedDataGrantSummariesEntry.Builder)ReceivedDataGrantSummariesEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReceivedDataGrantsResponse build() {
            return new ListReceivedDataGrantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReceivedDataGrantsResponse> {
        public Builder dataGrantSummaries(Collection<ReceivedDataGrantSummariesEntry> var1);

        public Builder dataGrantSummaries(ReceivedDataGrantSummariesEntry ... var1);

        public Builder dataGrantSummaries(Consumer<ReceivedDataGrantSummariesEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

