/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobErrorResourceTypes {
    REVISION("REVISION"),
    ASSET("ASSET"),
    DATA_SET("DATA_SET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobErrorResourceTypes> VALUE_MAP;
    private final String value;

    private JobErrorResourceTypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobErrorResourceTypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobErrorResourceTypes> knownValues() {
        EnumSet<JobErrorResourceTypes> knownValues = EnumSet.allOf(JobErrorResourceTypes.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobErrorResourceTypes.class, JobErrorResourceTypes::toString);
    }
}

