/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DataCatalogInputDefinition;
import software.amazon.awssdk.services.databrew.model.DatabaseInputDefinition;
import software.amazon.awssdk.services.databrew.model.Metadata;
import software.amazon.awssdk.services.databrew.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Input> {
    private static final SdkField<S3Location> S3_INPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3InputDefinition").getter(Input.getter(Input::s3InputDefinition)).setter(Input.setter(Builder::s3InputDefinition)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputDefinition").build()}).build();
    private static final SdkField<DataCatalogInputDefinition> DATA_CATALOG_INPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCatalogInputDefinition").getter(Input.getter(Input::dataCatalogInputDefinition)).setter(Input.setter(Builder::dataCatalogInputDefinition)).constructor(DataCatalogInputDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogInputDefinition").build()}).build();
    private static final SdkField<DatabaseInputDefinition> DATABASE_INPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseInputDefinition").getter(Input.getter(Input::databaseInputDefinition)).setter(Input.setter(Builder::databaseInputDefinition)).constructor(DatabaseInputDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInputDefinition").build()}).build();
    private static final SdkField<Metadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(Input.getter(Input::metadata)).setter(Input.setter(Builder::metadata)).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_DEFINITION_FIELD, DATA_CATALOG_INPUT_DEFINITION_FIELD, DATABASE_INPUT_DEFINITION_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Input.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Location s3InputDefinition;
    private final DataCatalogInputDefinition dataCatalogInputDefinition;
    private final DatabaseInputDefinition databaseInputDefinition;
    private final Metadata metadata;

    private Input(BuilderImpl builder) {
        this.s3InputDefinition = builder.s3InputDefinition;
        this.dataCatalogInputDefinition = builder.dataCatalogInputDefinition;
        this.databaseInputDefinition = builder.databaseInputDefinition;
        this.metadata = builder.metadata;
    }

    public final S3Location s3InputDefinition() {
        return this.s3InputDefinition;
    }

    public final DataCatalogInputDefinition dataCatalogInputDefinition() {
        return this.dataCatalogInputDefinition;
    }

    public final DatabaseInputDefinition databaseInputDefinition() {
        return this.databaseInputDefinition;
    }

    public final Metadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCatalogInputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.s3InputDefinition(), other.s3InputDefinition()) && Objects.equals(this.dataCatalogInputDefinition(), other.dataCatalogInputDefinition()) && Objects.equals(this.databaseInputDefinition(), other.databaseInputDefinition()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"Input").add("S3InputDefinition", (Object)this.s3InputDefinition()).add("DataCatalogInputDefinition", (Object)this.dataCatalogInputDefinition()).add("DatabaseInputDefinition", (Object)this.databaseInputDefinition()).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3InputDefinition": {
                return Optional.ofNullable(clazz.cast(this.s3InputDefinition()));
            }
            case "DataCatalogInputDefinition": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogInputDefinition()));
            }
            case "DatabaseInputDefinition": {
                return Optional.ofNullable(clazz.cast(this.databaseInputDefinition()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3InputDefinition", S3_INPUT_DEFINITION_FIELD);
        map.put("DataCatalogInputDefinition", DATA_CATALOG_INPUT_DEFINITION_FIELD);
        map.put("DatabaseInputDefinition", DATABASE_INPUT_DEFINITION_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Location s3InputDefinition;
        private DataCatalogInputDefinition dataCatalogInputDefinition;
        private DatabaseInputDefinition databaseInputDefinition;
        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.s3InputDefinition(model.s3InputDefinition);
            this.dataCatalogInputDefinition(model.dataCatalogInputDefinition);
            this.databaseInputDefinition(model.databaseInputDefinition);
            this.metadata(model.metadata);
        }

        public final S3Location.Builder getS3InputDefinition() {
            return this.s3InputDefinition != null ? this.s3InputDefinition.toBuilder() : null;
        }

        public final void setS3InputDefinition(S3Location.BuilderImpl s3InputDefinition) {
            this.s3InputDefinition = s3InputDefinition != null ? s3InputDefinition.build() : null;
        }

        @Override
        public final Builder s3InputDefinition(S3Location s3InputDefinition) {
            this.s3InputDefinition = s3InputDefinition;
            return this;
        }

        public final DataCatalogInputDefinition.Builder getDataCatalogInputDefinition() {
            return this.dataCatalogInputDefinition != null ? this.dataCatalogInputDefinition.toBuilder() : null;
        }

        public final void setDataCatalogInputDefinition(DataCatalogInputDefinition.BuilderImpl dataCatalogInputDefinition) {
            this.dataCatalogInputDefinition = dataCatalogInputDefinition != null ? dataCatalogInputDefinition.build() : null;
        }

        @Override
        public final Builder dataCatalogInputDefinition(DataCatalogInputDefinition dataCatalogInputDefinition) {
            this.dataCatalogInputDefinition = dataCatalogInputDefinition;
            return this;
        }

        public final DatabaseInputDefinition.Builder getDatabaseInputDefinition() {
            return this.databaseInputDefinition != null ? this.databaseInputDefinition.toBuilder() : null;
        }

        public final void setDatabaseInputDefinition(DatabaseInputDefinition.BuilderImpl databaseInputDefinition) {
            this.databaseInputDefinition = databaseInputDefinition != null ? databaseInputDefinition.build() : null;
        }

        @Override
        public final Builder databaseInputDefinition(DatabaseInputDefinition databaseInputDefinition) {
            this.databaseInputDefinition = databaseInputDefinition;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Input build() {
            return new Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Input> {
        public Builder s3InputDefinition(S3Location var1);

        default public Builder s3InputDefinition(Consumer<S3Location.Builder> s3InputDefinition) {
            return this.s3InputDefinition((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3InputDefinition)).build());
        }

        public Builder dataCatalogInputDefinition(DataCatalogInputDefinition var1);

        default public Builder dataCatalogInputDefinition(Consumer<DataCatalogInputDefinition.Builder> dataCatalogInputDefinition) {
            return this.dataCatalogInputDefinition((DataCatalogInputDefinition)((DataCatalogInputDefinition.Builder)DataCatalogInputDefinition.builder().applyMutation(dataCatalogInputDefinition)).build());
        }

        public Builder databaseInputDefinition(DatabaseInputDefinition var1);

        default public Builder databaseInputDefinition(Consumer<DatabaseInputDefinition.Builder> databaseInputDefinition) {
            return this.databaseInputDefinition((DatabaseInputDefinition)((DatabaseInputDefinition.Builder)DatabaseInputDefinition.builder().applyMutation(databaseInputDefinition)).build());
        }

        public Builder metadata(Metadata var1);

        default public Builder metadata(Consumer<Metadata.Builder> metadata) {
            return this.metadata((Metadata)((Metadata.Builder)Metadata.builder().applyMutation(metadata)).build());
        }
    }
}

