/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.ColumnSelector;
import software.amazon.awssdk.services.databrew.model.ColumnSelectorListCopier;
import software.amazon.awssdk.services.databrew.model.StatisticsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnStatisticsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnStatisticsConfiguration> {
    private static final SdkField<List<ColumnSelector>> SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Selectors").getter(ColumnStatisticsConfiguration.getter(ColumnStatisticsConfiguration::selectors)).setter(ColumnStatisticsConfiguration.setter(Builder::selectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StatisticsConfiguration> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(ColumnStatisticsConfiguration.getter(ColumnStatisticsConfiguration::statistics)).setter(ColumnStatisticsConfiguration.setter(Builder::statistics)).constructor(StatisticsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTORS_FIELD, STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnStatisticsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ColumnSelector> selectors;
    private final StatisticsConfiguration statistics;

    private ColumnStatisticsConfiguration(BuilderImpl builder) {
        this.selectors = builder.selectors;
        this.statistics = builder.statistics;
    }

    public final boolean hasSelectors() {
        return this.selectors != null && !(this.selectors instanceof SdkAutoConstructList);
    }

    public final List<ColumnSelector> selectors() {
        return this.selectors;
    }

    public final StatisticsConfiguration statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectors() ? this.selectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsConfiguration)) {
            return false;
        }
        ColumnStatisticsConfiguration other = (ColumnStatisticsConfiguration)obj;
        return this.hasSelectors() == other.hasSelectors() && Objects.equals(this.selectors(), other.selectors()) && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnStatisticsConfiguration").add("Selectors", this.hasSelectors() ? this.selectors() : null).add("Statistics", (Object)this.statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Selectors": {
                return Optional.ofNullable(clazz.cast(this.selectors()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Selectors", SELECTORS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsConfiguration, T> g) {
        return obj -> g.apply((ColumnStatisticsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnSelector> selectors = DefaultSdkAutoConstructList.getInstance();
        private StatisticsConfiguration statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsConfiguration model) {
            this.selectors(model.selectors);
            this.statistics(model.statistics);
        }

        public final List<ColumnSelector.Builder> getSelectors() {
            List<ColumnSelector.Builder> result = ColumnSelectorListCopier.copyToBuilder(this.selectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectors(Collection<ColumnSelector.BuilderImpl> selectors) {
            this.selectors = ColumnSelectorListCopier.copyFromBuilder(selectors);
        }

        @Override
        public final Builder selectors(Collection<ColumnSelector> selectors) {
            this.selectors = ColumnSelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(ColumnSelector ... selectors) {
            this.selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<ColumnSelector.Builder> ... selectors) {
            this.selectors(Stream.of(selectors).map(c -> (ColumnSelector)((ColumnSelector.Builder)ColumnSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StatisticsConfiguration.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(StatisticsConfiguration.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(StatisticsConfiguration statistics) {
            this.statistics = statistics;
            return this;
        }

        public ColumnStatisticsConfiguration build() {
            return new ColumnStatisticsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnStatisticsConfiguration> {
        public Builder selectors(Collection<ColumnSelector> var1);

        public Builder selectors(ColumnSelector ... var1);

        public Builder selectors(Consumer<ColumnSelector.Builder> ... var1);

        public Builder statistics(StatisticsConfiguration var1);

        default public Builder statistics(Consumer<StatisticsConfiguration.Builder> statistics) {
            return this.statistics((StatisticsConfiguration)((StatisticsConfiguration.Builder)StatisticsConfiguration.builder().applyMutation(statistics)).build());
        }
    }
}

