/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Source {
    S3("S3"),
    DATA_CATALOG("DATA-CATALOG"),
    DATABASE("DATABASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Source> VALUE_MAP;
    private final String value;

    private Source(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Source fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Source> knownValues() {
        EnumSet<Source> knownValues = EnumSet.allOf(Source.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Source.class, Source::toString);
    }
}

