/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.Recipe;
import software.amazon.awssdk.services.databrew.model.RecipeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecipesResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, ListRecipesResponse> {
    private static final SdkField<List<Recipe>> RECIPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recipes").getter(ListRecipesResponse.getter(ListRecipesResponse::recipes)).setter(ListRecipesResponse.setter(Builder::recipes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Recipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecipesResponse.getter(ListRecipesResponse::nextToken)).setter(ListRecipesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecipesResponse.memberNameToFieldInitializer();
    private final List<Recipe> recipes;
    private final String nextToken;

    private ListRecipesResponse(BuilderImpl builder) {
        super(builder);
        this.recipes = builder.recipes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRecipes() {
        return this.recipes != null && !(this.recipes instanceof SdkAutoConstructList);
    }

    public final List<Recipe> recipes() {
        return this.recipes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipes() ? this.recipes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecipesResponse)) {
            return false;
        }
        ListRecipesResponse other = (ListRecipesResponse)((Object)obj);
        return this.hasRecipes() == other.hasRecipes() && Objects.equals(this.recipes(), other.recipes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecipesResponse").add("Recipes", this.hasRecipes() ? this.recipes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Recipes": {
                return Optional.ofNullable(clazz.cast(this.recipes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Recipes", RECIPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecipesResponse, T> g) {
        return obj -> g.apply((ListRecipesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private List<Recipe> recipes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecipesResponse model) {
            super(model);
            this.recipes(model.recipes);
            this.nextToken(model.nextToken);
        }

        public final List<Recipe.Builder> getRecipes() {
            List<Recipe.Builder> result = RecipeListCopier.copyToBuilder(this.recipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipes(Collection<Recipe.BuilderImpl> recipes) {
            this.recipes = RecipeListCopier.copyFromBuilder(recipes);
        }

        @Override
        public final Builder recipes(Collection<Recipe> recipes) {
            this.recipes = RecipeListCopier.copy(recipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(Recipe ... recipes) {
            this.recipes(Arrays.asList(recipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(Consumer<Recipe.Builder> ... recipes) {
            this.recipes(Stream.of(recipes).map(c -> (Recipe)((Recipe.Builder)Recipe.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecipesResponse build() {
            return new ListRecipesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecipesResponse> {
        public Builder recipes(Collection<Recipe> var1);

        public Builder recipes(Recipe ... var1);

        public Builder recipes(Consumer<Recipe.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

