/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewAsyncClient;
import software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest;
import software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse;
import software.amazon.awssdk.services.databrew.model.Recipe;

public class ListRecipeVersionsPublisher
implements SdkPublisher<ListRecipeVersionsResponse> {
    private final DataBrewAsyncClient client;
    private final ListRecipeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecipeVersionsPublisher(DataBrewAsyncClient client, ListRecipeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecipeVersionsPublisher(DataBrewAsyncClient client, ListRecipeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecipeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecipeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Recipe> recipes() {
        Function<ListRecipeVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recipes() != null) {
                return response.recipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecipeVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecipeVersionsResponseFetcher
    implements AsyncPageFetcher<ListRecipeVersionsResponse> {
        private ListRecipeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecipeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecipeVersionsResponse> nextPage(ListRecipeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListRecipeVersionsPublisher.this.client.listRecipeVersions(ListRecipeVersionsPublisher.this.firstRequest);
            }
            return ListRecipeVersionsPublisher.this.client.listRecipeVersions((ListRecipeVersionsRequest)((Object)ListRecipeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

