/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.StatisticListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllowedStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AllowedStatistics> {
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statistics").getter(AllowedStatistics.getter(AllowedStatistics::statistics)).setter(AllowedStatistics.setter(Builder::statistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> statistics;

    private AllowedStatistics(BuilderImpl builder) {
        this.statistics = builder.statistics;
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<String> statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statistics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedStatistics)) {
            return false;
        }
        AllowedStatistics other = (AllowedStatistics)obj;
        return this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"AllowedStatistics").add("Statistics", this.hasStatistics() ? this.statistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowedStatistics, T> g) {
        return obj -> g.apply((AllowedStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedStatistics model) {
            this.statistics(model.statistics);
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = StatisticListCopier.copy(statistics);
        }

        @Override
        @Transient
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = StatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statistics(String ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public AllowedStatistics build() {
            return new AllowedStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AllowedStatistics> {
        public Builder statistics(Collection<String> var1);

        public Builder statistics(String ... var1);
    }
}

