/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecipeJobRequest extends DataBrewRequest implements
        ToCopyableBuilder<UpdateRecipeJobRequest.Builder, UpdateRecipeJobRequest> {
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(UpdateRecipeJobRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionMode").getter(getter(UpdateRecipeJobRequest::encryptionModeAsString))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateRecipeJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogSubscription").getter(getter(UpdateRecipeJobRequest::logSubscriptionAsString))
            .setter(setter(Builder::logSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(UpdateRecipeJobRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(UpdateRecipeJobRequest::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(UpdateRecipeJobRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataCatalogOutput>> DATA_CATALOG_OUTPUTS_FIELD = SdkField
            .<List<DataCatalogOutput>> builder(MarshallingType.LIST)
            .memberName("DataCatalogOutputs")
            .getter(getter(UpdateRecipeJobRequest::dataCatalogOutputs))
            .setter(setter(Builder::dataCatalogOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogOutputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataCatalogOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataCatalogOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatabaseOutput>> DATABASE_OUTPUTS_FIELD = SdkField
            .<List<DatabaseOutput>> builder(MarshallingType.LIST)
            .memberName("DatabaseOutputs")
            .getter(getter(UpdateRecipeJobRequest::databaseOutputs))
            .setter(setter(Builder::databaseOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOutputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatabaseOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatabaseOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateRecipeJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(UpdateRecipeJobRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_ARN_FIELD,
            ENCRYPTION_MODE_FIELD, NAME_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD, OUTPUTS_FIELD,
            DATA_CATALOG_OUTPUTS_FIELD, DATABASE_OUTPUTS_FIELD, ROLE_ARN_FIELD, TIMEOUT_FIELD));

    private final String encryptionKeyArn;

    private final String encryptionMode;

    private final String name;

    private final String logSubscription;

    private final Integer maxCapacity;

    private final Integer maxRetries;

    private final List<Output> outputs;

    private final List<DataCatalogOutput> dataCatalogOutputs;

    private final List<DatabaseOutput> databaseOutputs;

    private final String roleArn;

    private final Integer timeout;

    private UpdateRecipeJobRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputs = builder.outputs;
        this.dataCatalogOutputs = builder.dataCatalogOutputs;
        this.databaseOutputs = builder.databaseOutputs;
        this.roleArn = builder.roleArn;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * The name of the job to update.
     * </p>
     * 
     * @return The name of the job to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
     * stream for each job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one
     *         log stream for each job run.
     * @see LogSubscription
     */
    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(logSubscription);
    }

    /**
     * <p>
     * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
     * stream for each job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one
     *         log stream for each job run.
     * @see LogSubscription
     */
    public final String logSubscriptionAsString() {
        return logSubscription;
    }

    /**
     * <p>
     * The maximum number of nodes that DataBrew can consume when the job processes data.
     * </p>
     * 
     * @return The maximum number of nodes that DataBrew can consume when the job processes data.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The maximum number of times to retry the job after a job run fails.
     * </p>
     * 
     * @return The maximum number of times to retry the job after a job run fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more artifacts that represent the output from running the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return One or more artifacts that represent the output from running the job.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataCatalogOutputs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataCatalogOutputs() {
        return dataCatalogOutputs != null && !(dataCatalogOutputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more artifacts that represent the Glue Data Catalog output from running the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataCatalogOutputs} method.
     * </p>
     * 
     * @return One or more artifacts that represent the Glue Data Catalog output from running the job.
     */
    public final List<DataCatalogOutput> dataCatalogOutputs() {
        return dataCatalogOutputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatabaseOutputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatabaseOutputs() {
        return databaseOutputs != null && !(databaseOutputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job
     * to write into.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatabaseOutputs} method.
     * </p>
     * 
     * @return Represents a list of JDBC database output objects which defines the output destination for a DataBrew
     *         recipe job to write into.
     */
    public final List<DatabaseOutput> databaseOutputs() {
        return databaseOutputs;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs
     * the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when
     *         DataBrew runs the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of
     * <code>TIMEOUT</code>.
     * </p>
     * 
     * @return The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
     *         status of <code>TIMEOUT</code>.
     */
    public final Integer timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataCatalogOutputs() ? dataCatalogOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDatabaseOutputs() ? databaseOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecipeJobRequest)) {
            return false;
        }
        UpdateRecipeJobRequest other = (UpdateRecipeJobRequest) obj;
        return Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(logSubscriptionAsString(), other.logSubscriptionAsString())
                && Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(maxRetries(), other.maxRetries())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && hasDataCatalogOutputs() == other.hasDataCatalogOutputs()
                && Objects.equals(dataCatalogOutputs(), other.dataCatalogOutputs())
                && hasDatabaseOutputs() == other.hasDatabaseOutputs()
                && Objects.equals(databaseOutputs(), other.databaseOutputs()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecipeJobRequest").add("EncryptionKeyArn", encryptionKeyArn())
                .add("EncryptionMode", encryptionModeAsString()).add("Name", name())
                .add("LogSubscription", logSubscriptionAsString()).add("MaxCapacity", maxCapacity())
                .add("MaxRetries", maxRetries()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("DataCatalogOutputs", hasDataCatalogOutputs() ? dataCatalogOutputs() : null)
                .add("DatabaseOutputs", hasDatabaseOutputs() ? databaseOutputs() : null).add("RoleArn", roleArn())
                .add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LogSubscription":
            return Optional.ofNullable(clazz.cast(logSubscriptionAsString()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "DataCatalogOutputs":
            return Optional.ofNullable(clazz.cast(dataCatalogOutputs()));
        case "DatabaseOutputs":
            return Optional.ofNullable(clazz.cast(databaseOutputs()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecipeJobRequest, T> g) {
        return obj -> g.apply((UpdateRecipeJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRecipeJobRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(EncryptionMode encryptionMode);

        /**
         * <p>
         * The name of the job to update.
         * </p>
         * 
         * @param name
         *        The name of the job to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
         * stream for each job run.
         * </p>
         * 
         * @param logSubscription
         *        Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes
         *        one log stream for each job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(String logSubscription);

        /**
         * <p>
         * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
         * stream for each job run.
         * </p>
         * 
         * @param logSubscription
         *        Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes
         *        one log stream for each job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(LogSubscription logSubscription);

        /**
         * <p>
         * The maximum number of nodes that DataBrew can consume when the job processes data.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of nodes that DataBrew can consume when the job processes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The maximum number of times to retry the job after a job run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry the job after a job run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * 
         * @param outputs
         *        One or more artifacts that represent the output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * 
         * @param outputs
         *        One or more artifacts that represent the output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Output>.Builder} avoiding the need to
         * create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * One or more artifacts that represent the Glue Data Catalog output from running the job.
         * </p>
         * 
         * @param dataCatalogOutputs
         *        One or more artifacts that represent the Glue Data Catalog output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs);

        /**
         * <p>
         * One or more artifacts that represent the Glue Data Catalog output from running the job.
         * </p>
         * 
         * @param dataCatalogOutputs
         *        One or more artifacts that represent the Glue Data Catalog output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalogOutputs(DataCatalogOutput... dataCatalogOutputs);

        /**
         * <p>
         * One or more artifacts that represent the Glue Data Catalog output from running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataCatalogOutput>.Builder} avoiding the
         * need to create one manually via {@link List<DataCatalogOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataCatalogOutput>.Builder#build()} is called immediately
         * and its result is passed to {@link #dataCatalogOutputs(List<DataCatalogOutput>)}.
         * 
         * @param dataCatalogOutputs
         *        a consumer that will call methods on {@link List<DataCatalogOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCatalogOutputs(List<DataCatalogOutput>)
         */
        Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder>... dataCatalogOutputs);

        /**
         * <p>
         * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe
         * job to write into.
         * </p>
         * 
         * @param databaseOutputs
         *        Represents a list of JDBC database output objects which defines the output destination for a DataBrew
         *        recipe job to write into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseOutputs(Collection<DatabaseOutput> databaseOutputs);

        /**
         * <p>
         * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe
         * job to write into.
         * </p>
         * 
         * @param databaseOutputs
         *        Represents a list of JDBC database output objects which defines the output destination for a DataBrew
         *        recipe job to write into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseOutputs(DatabaseOutput... databaseOutputs);

        /**
         * <p>
         * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe
         * job to write into.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatabaseOutput>.Builder} avoiding the need
         * to create one manually via {@link List<DatabaseOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatabaseOutput>.Builder#build()} is called immediately and
         * its result is passed to {@link #databaseOutputs(List<DatabaseOutput>)}.
         * 
         * @param databaseOutputs
         *        a consumer that will call methods on {@link List<DatabaseOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseOutputs(List<DatabaseOutput>)
         */
        Builder databaseOutputs(Consumer<DatabaseOutput.Builder>... databaseOutputs);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew
         * runs the job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when
         *        DataBrew runs the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status
         * of <code>TIMEOUT</code>.
         * </p>
         * 
         * @param timeout
         *        The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
         *        status of <code>TIMEOUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private String encryptionKeyArn;

        private String encryptionMode;

        private String name;

        private String logSubscription;

        private Integer maxCapacity;

        private Integer maxRetries;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private List<DataCatalogOutput> dataCatalogOutputs = DefaultSdkAutoConstructList.getInstance();

        private List<DatabaseOutput> databaseOutputs = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecipeJobRequest model) {
            super(model);
            encryptionKeyArn(model.encryptionKeyArn);
            encryptionMode(model.encryptionMode);
            name(model.name);
            logSubscription(model.logSubscription);
            maxCapacity(model.maxCapacity);
            maxRetries(model.maxRetries);
            outputs(model.outputs);
            dataCatalogOutputs(model.dataCatalogOutputs);
            databaseOutputs(model.databaseOutputs);
            roleArn(model.roleArn);
            timeout(model.timeout);
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        @Transient
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        @Transient
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLogSubscription() {
            return logSubscription;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        @Override
        @Transient
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        @Transient
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        @Transient
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        @Transient
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataCatalogOutput.Builder> getDataCatalogOutputs() {
            List<DataCatalogOutput.Builder> result = DataCatalogOutputListCopier.copyToBuilder(this.dataCatalogOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataCatalogOutputs(Collection<DataCatalogOutput.BuilderImpl> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copyFromBuilder(dataCatalogOutputs);
        }

        @Override
        @Transient
        public final Builder dataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copy(dataCatalogOutputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataCatalogOutputs(DataCatalogOutput... dataCatalogOutputs) {
            dataCatalogOutputs(Arrays.asList(dataCatalogOutputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder>... dataCatalogOutputs) {
            dataCatalogOutputs(Stream.of(dataCatalogOutputs).map(c -> DataCatalogOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DatabaseOutput.Builder> getDatabaseOutputs() {
            List<DatabaseOutput.Builder> result = DatabaseOutputListCopier.copyToBuilder(this.databaseOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabaseOutputs(Collection<DatabaseOutput.BuilderImpl> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copyFromBuilder(databaseOutputs);
        }

        @Override
        @Transient
        public final Builder databaseOutputs(Collection<DatabaseOutput> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copy(databaseOutputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder databaseOutputs(DatabaseOutput... databaseOutputs) {
            databaseOutputs(Arrays.asList(databaseOutputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder databaseOutputs(Consumer<DatabaseOutput.Builder>... databaseOutputs) {
            databaseOutputs(Stream.of(databaseOutputs).map(c -> DatabaseOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        @Transient
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecipeJobRequest build() {
            return new UpdateRecipeJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
