/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the sample size and sampling type for DataBrew to use for interactive data analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sample implements SdkPojo, Serializable, ToCopyableBuilder<Sample.Builder, Sample> {
    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(Sample::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Sample::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer size;

    private final String type;

    private Sample(BuilderImpl builder) {
        this.size = builder.size;
        this.type = builder.type;
    }

    /**
     * <p>
     * The number of rows in the sample.
     * </p>
     * 
     * @return The number of rows in the sample.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The way in which DataBrew obtains rows from a dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SampleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The way in which DataBrew obtains rows from a dataset.
     * @see SampleType
     */
    public final SampleType type() {
        return SampleType.fromValue(type);
    }

    /**
     * <p>
     * The way in which DataBrew obtains rows from a dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SampleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The way in which DataBrew obtains rows from a dataset.
     * @see SampleType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample) obj;
        return Objects.equals(size(), other.size()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sample").add("Size", size()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Sample, T> g) {
        return obj -> g.apply((Sample) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sample> {
        /**
         * <p>
         * The number of rows in the sample.
         * </p>
         * 
         * @param size
         *        The number of rows in the sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The way in which DataBrew obtains rows from a dataset.
         * </p>
         * 
         * @param type
         *        The way in which DataBrew obtains rows from a dataset.
         * @see SampleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleType
         */
        Builder type(String type);

        /**
         * <p>
         * The way in which DataBrew obtains rows from a dataset.
         * </p>
         * 
         * @param type
         *        The way in which DataBrew obtains rows from a dataset.
         * @see SampleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleType
         */
        Builder type(SampleType type);
    }

    static final class BuilderImpl implements Builder {
        private Integer size;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Sample model) {
            size(model.size);
            type(model.type);
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        @Transient
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(SampleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Sample build() {
            return new Sample(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
