/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecipesRequest extends DataBrewRequest implements
        ToCopyableBuilder<ListRecipesRequest.Builder, ListRecipesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRecipesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRecipesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RECIPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeVersion").getter(getter(ListRecipesRequest::recipeVersion)).setter(setter(Builder::recipeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recipeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RECIPE_VERSION_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String recipeVersion;

    private ListRecipesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.recipeVersion = builder.recipeVersion;
    }

    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     * 
     * @return The maximum number of results to return in this request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned by a previous call to retrieve the next set of results.
     * </p>
     * 
     * @return The token returned by a previous call to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
     * <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code> returns all of
     * the <code>LATEST_PUBLISHED</code> recipe versions.
     * </p>
     * <p>
     * Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
     * </p>
     * 
     * @return Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
     *         <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code> returns
     *         all of the <code>LATEST_PUBLISHED</code> recipe versions.</p>
     *         <p>
     *         Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
     */
    public final String recipeVersion() {
        return recipeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recipeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecipesRequest)) {
            return false;
        }
        ListRecipesRequest other = (ListRecipesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(recipeVersion(), other.recipeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecipesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("RecipeVersion", recipeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RecipeVersion":
            return Optional.ofNullable(clazz.cast(recipeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecipesRequest, T> g) {
        return obj -> g.apply((ListRecipesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecipesRequest> {
        /**
         * <p>
         * The maximum number of results to return in this request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned by a previous call to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
         * <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code> returns all
         * of the <code>LATEST_PUBLISHED</code> recipe versions.
         * </p>
         * <p>
         * Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
         * </p>
         * 
         * @param recipeVersion
         *        Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
         *        <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code>
         *        returns all of the <code>LATEST_PUBLISHED</code> recipe versions.</p>
         *        <p>
         *        Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeVersion(String recipeVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String recipeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecipesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            recipeVersion(model.recipeVersion);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRecipeVersion() {
            return recipeVersion;
        }

        public final void setRecipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
        }

        @Override
        @Transient
        public final Builder recipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecipesRequest build() {
            return new ListRecipesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
