/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends DataBrewResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeDatasetResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(DescribeDatasetResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeDatasetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(DescribeDatasetResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField
            .<FormatOptions> builder(MarshallingType.SDK_POJO).memberName("FormatOptions")
            .getter(getter(DescribeDatasetResponse::formatOptions)).setter(setter(Builder::formatOptions))
            .constructor(FormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatOptions").build()).build();

    private static final SdkField<Input> INPUT_FIELD = SdkField.<Input> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(DescribeDatasetResponse::input)).setter(setter(Builder::input)).constructor(Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(DescribeDatasetResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(DescribeDatasetResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(DescribeDatasetResponse::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<PathOptions> PATH_OPTIONS_FIELD = SdkField.<PathOptions> builder(MarshallingType.SDK_POJO)
            .memberName("PathOptions").getter(getter(DescribeDatasetResponse::pathOptions)).setter(setter(Builder::pathOptions))
            .constructor(PathOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathOptions").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeDatasetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeDatasetResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            CREATE_DATE_FIELD, NAME_FIELD, FORMAT_FIELD, FORMAT_OPTIONS_FIELD, INPUT_FIELD, LAST_MODIFIED_DATE_FIELD,
            LAST_MODIFIED_BY_FIELD, SOURCE_FIELD, PATH_OPTIONS_FIELD, TAGS_FIELD, RESOURCE_ARN_FIELD));

    private final String createdBy;

    private final Instant createDate;

    private final String name;

    private final String format;

    private final FormatOptions formatOptions;

    private final Input input;

    private final Instant lastModifiedDate;

    private final String lastModifiedBy;

    private final String source;

    private final PathOptions pathOptions;

    private final Map<String, String> tags;

    private final String resourceArn;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.name = builder.name;
        this.format = builder.format;
        this.formatOptions = builder.formatOptions;
        this.input = builder.input;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.source = builder.source;
        this.pathOptions = builder.pathOptions;
        this.tags = builder.tags;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The identifier (user name) of the user who created the dataset.
     * </p>
     * 
     * @return The identifier (user name) of the user who created the dataset.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the dataset was created.
     * </p>
     * 
     * @return The date and time that the dataset was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The file format of a dataset that is created from an Amazon S3 file or folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The file format of a dataset that is created from an Amazon S3 file or folder.
     * @see InputFormat
     */
    public final InputFormat format() {
        return InputFormat.fromValue(format);
    }

    /**
     * <p>
     * The file format of a dataset that is created from an Amazon S3 file or folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The file format of a dataset that is created from an Amazon S3 file or folder.
     * @see InputFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * Returns the value of the FormatOptions property for this object.
     * 
     * @return The value of the FormatOptions property for this object.
     */
    public final FormatOptions formatOptions() {
        return formatOptions;
    }

    /**
     * Returns the value of the Input property for this object.
     * 
     * @return The value of the Input property for this object.
     */
    public final Input input() {
        return input;
    }

    /**
     * <p>
     * The date and time that the dataset was last modified.
     * </p>
     * 
     * @return The date and time that the dataset was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The identifier (user name) of the user who last modified the dataset.
     * </p>
     * 
     * @return The identifier (user name) of the user who last modified the dataset.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
     * @see Source
     */
    public final Source source() {
        return Source.fromValue(source);
    }

    /**
     * <p>
     * The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
     * @see Source
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
     * </p>
     * 
     * @return A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
     */
    public final PathOptions pathOptions() {
        return pathOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags associated with this dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata tags associated with this dataset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pathOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(name(), other.name()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(formatOptions(), other.formatOptions()) && Objects.equals(input(), other.input())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(sourceAsString(), other.sourceAsString()) && Objects.equals(pathOptions(), other.pathOptions())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("CreatedBy", createdBy()).add("CreateDate", createDate())
                .add("Name", name()).add("Format", formatAsString()).add("FormatOptions", formatOptions()).add("Input", input())
                .add("LastModifiedDate", lastModifiedDate()).add("LastModifiedBy", lastModifiedBy())
                .add("Source", sourceAsString()).add("PathOptions", pathOptions()).add("Tags", hasTags() ? tags() : null)
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "FormatOptions":
            return Optional.ofNullable(clazz.cast(formatOptions()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "PathOptions":
            return Optional.ofNullable(clazz.cast(pathOptions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The identifier (user name) of the user who created the dataset.
         * </p>
         * 
         * @param createdBy
         *        The identifier (user name) of the user who created the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the dataset was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param name
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The file format of a dataset that is created from an Amazon S3 file or folder.
         * </p>
         * 
         * @param format
         *        The file format of a dataset that is created from an Amazon S3 file or folder.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The file format of a dataset that is created from an Amazon S3 file or folder.
         * </p>
         * 
         * @param format
         *        The file format of a dataset that is created from an Amazon S3 file or folder.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder format(InputFormat format);

        /**
         * Sets the value of the FormatOptions property for this object.
         *
         * @param formatOptions
         *        The new value for the FormatOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatOptions(FormatOptions formatOptions);

        /**
         * Sets the value of the FormatOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link FormatOptions.Builder} avoiding the need to
         * create one manually via {@link FormatOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link FormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #formatOptions(FormatOptions)}.
         * 
         * @param formatOptions
         *        a consumer that will call methods on {@link FormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatOptions(FormatOptions)
         */
        default Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return formatOptions(FormatOptions.builder().applyMutation(formatOptions).build());
        }

        /**
         * Sets the value of the Input property for this object.
         *
         * @param input
         *        The new value for the Input property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);

        /**
         * Sets the value of the Input property for this object.
         *
         * This is a convenience that creates an instance of the {@link Input.Builder} avoiding the need to create one
         * manually via {@link Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link Input.Builder#build()} is called immediately and its result is
         * passed to {@link #input(Input)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(Input)
         */
        default Builder input(Consumer<Input.Builder> input) {
            return input(Input.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The date and time that the dataset was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time that the dataset was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The identifier (user name) of the user who last modified the dataset.
         * </p>
         * 
         * @param lastModifiedBy
         *        The identifier (user name) of the user who last modified the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
         * </p>
         * 
         * @param source
         *        The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(String source);

        /**
         * <p>
         * The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
         * </p>
         * 
         * @param source
         *        The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(Source source);

        /**
         * <p>
         * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
         * </p>
         * 
         * @param pathOptions
         *        A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathOptions(PathOptions pathOptions);

        /**
         * <p>
         * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link PathOptions.Builder} avoiding the need to create
         * one manually via {@link PathOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link PathOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #pathOptions(PathOptions)}.
         * 
         * @param pathOptions
         *        a consumer that will call methods on {@link PathOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pathOptions(PathOptions)
         */
        default Builder pathOptions(Consumer<PathOptions.Builder> pathOptions) {
            return pathOptions(PathOptions.builder().applyMutation(pathOptions).build());
        }

        /**
         * <p>
         * Metadata tags associated with this dataset.
         * </p>
         * 
         * @param tags
         *        Metadata tags associated with this dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private String createdBy;

        private Instant createDate;

        private String name;

        private String format;

        private FormatOptions formatOptions;

        private Input input;

        private Instant lastModifiedDate;

        private String lastModifiedBy;

        private String source;

        private PathOptions pathOptions;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            createdBy(model.createdBy);
            createDate(model.createDate);
            name(model.name);
            format(model.format);
            formatOptions(model.formatOptions);
            input(model.input);
            lastModifiedDate(model.lastModifiedDate);
            lastModifiedBy(model.lastModifiedBy);
            source(model.source);
            pathOptions(model.pathOptions);
            tags(model.tags);
            resourceArn(model.resourceArn);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(InputFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return formatOptions != null ? formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final Input.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        @Transient
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        @Transient
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final PathOptions.Builder getPathOptions() {
            return pathOptions != null ? pathOptions.toBuilder() : null;
        }

        public final void setPathOptions(PathOptions.BuilderImpl pathOptions) {
            this.pathOptions = pathOptions != null ? pathOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder pathOptions(PathOptions pathOptions) {
            this.pathOptions = pathOptions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
