/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelReference;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetadataModelChildrenResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeMetadataModelChildrenResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeMetadataModelChildrenResponse.getter(DescribeMetadataModelChildrenResponse::marker)).setter(DescribeMetadataModelChildrenResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<MetadataModelReference>> METADATA_MODEL_CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetadataModelChildren").getter(DescribeMetadataModelChildrenResponse.getter(DescribeMetadataModelChildrenResponse::metadataModelChildren)).setter(DescribeMetadataModelChildrenResponse.setter(Builder::metadataModelChildren)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelChildren").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataModelReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, METADATA_MODEL_CHILDREN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMetadataModelChildrenResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<MetadataModelReference> metadataModelChildren;

    private DescribeMetadataModelChildrenResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.metadataModelChildren = builder.metadataModelChildren;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasMetadataModelChildren() {
        return this.metadataModelChildren != null && !(this.metadataModelChildren instanceof SdkAutoConstructList);
    }

    public final List<MetadataModelReference> metadataModelChildren() {
        return this.metadataModelChildren;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataModelChildren() ? this.metadataModelChildren() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetadataModelChildrenResponse)) {
            return false;
        }
        DescribeMetadataModelChildrenResponse other = (DescribeMetadataModelChildrenResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasMetadataModelChildren() == other.hasMetadataModelChildren() && Objects.equals(this.metadataModelChildren(), other.metadataModelChildren());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetadataModelChildrenResponse").add("Marker", (Object)this.marker()).add("MetadataModelChildren", this.hasMetadataModelChildren() ? this.metadataModelChildren() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MetadataModelChildren": {
                return Optional.ofNullable(clazz.cast(this.metadataModelChildren()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("MetadataModelChildren", METADATA_MODEL_CHILDREN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetadataModelChildrenResponse, T> g) {
        return obj -> g.apply((DescribeMetadataModelChildrenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<MetadataModelReference> metadataModelChildren = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetadataModelChildrenResponse model) {
            super(model);
            this.marker(model.marker);
            this.metadataModelChildren(model.metadataModelChildren);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<MetadataModelReference.Builder> getMetadataModelChildren() {
            List<MetadataModelReference.Builder> result = MetadataModelReferenceListCopier.copyToBuilder(this.metadataModelChildren);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataModelChildren(Collection<MetadataModelReference.BuilderImpl> metadataModelChildren) {
            this.metadataModelChildren = MetadataModelReferenceListCopier.copyFromBuilder(metadataModelChildren);
        }

        @Override
        public final Builder metadataModelChildren(Collection<MetadataModelReference> metadataModelChildren) {
            this.metadataModelChildren = MetadataModelReferenceListCopier.copy(metadataModelChildren);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataModelChildren(MetadataModelReference ... metadataModelChildren) {
            this.metadataModelChildren(Arrays.asList(metadataModelChildren));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataModelChildren(Consumer<MetadataModelReference.Builder> ... metadataModelChildren) {
            this.metadataModelChildren(Stream.of(metadataModelChildren).map(c -> (MetadataModelReference)((MetadataModelReference.Builder)MetadataModelReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMetadataModelChildrenResponse build() {
            return new DescribeMetadataModelChildrenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetadataModelChildrenResponse> {
        public Builder marker(String var1);

        public Builder metadataModelChildren(Collection<MetadataModelReference> var1);

        public Builder metadataModelChildren(MetadataModelReference ... var1);

        public Builder metadataModelChildren(Consumer<MetadataModelReference.Builder> ... var1);
    }
}

