/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProviderDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProviderDescriptor> {
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(DataProviderDescriptor.getter(DataProviderDescriptor::secretsManagerSecretId)).setter(DataProviderDescriptor.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(DataProviderDescriptor.getter(DataProviderDescriptor::secretsManagerAccessRoleArn)).setter(DataProviderDescriptor.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> DATA_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderName").getter(DataProviderDescriptor.getter(DataProviderDescriptor::dataProviderName)).setter(DataProviderDescriptor.setter(Builder::dataProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderName").build()}).build();
    private static final SdkField<String> DATA_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderArn").getter(DataProviderDescriptor.getter(DataProviderDescriptor::dataProviderArn)).setter(DataProviderDescriptor.setter(Builder::dataProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRETS_MANAGER_SECRET_ID_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, DATA_PROVIDER_NAME_FIELD, DATA_PROVIDER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProviderDescriptor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String secretsManagerSecretId;
    private final String secretsManagerAccessRoleArn;
    private final String dataProviderName;
    private final String dataProviderArn;

    private DataProviderDescriptor(BuilderImpl builder) {
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.dataProviderName = builder.dataProviderName;
        this.dataProviderArn = builder.dataProviderArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String dataProviderName() {
        return this.dataProviderName;
    }

    public final String dataProviderArn() {
        return this.dataProviderArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProviderDescriptor)) {
            return false;
        }
        DataProviderDescriptor other = (DataProviderDescriptor)obj;
        return Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.dataProviderName(), other.dataProviderName()) && Objects.equals(this.dataProviderArn(), other.dataProviderArn());
    }

    public final String toString() {
        return ToString.builder((String)"DataProviderDescriptor").add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("DataProviderName", (Object)this.dataProviderName()).add("DataProviderArn", (Object)this.dataProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "DataProviderName": {
                return Optional.ofNullable(clazz.cast(this.dataProviderName()));
            }
            case "DataProviderArn": {
                return Optional.ofNullable(clazz.cast(this.dataProviderArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("DataProviderName", DATA_PROVIDER_NAME_FIELD);
        map.put("DataProviderArn", DATA_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProviderDescriptor, T> g) {
        return obj -> g.apply((DataProviderDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretsManagerSecretId;
        private String secretsManagerAccessRoleArn;
        private String dataProviderName;
        private String dataProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProviderDescriptor model) {
            this.secretsManagerSecretId(model.secretsManagerSecretId);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.dataProviderName(model.dataProviderName);
            this.dataProviderArn(model.dataProviderArn);
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getDataProviderName() {
            return this.dataProviderName;
        }

        public final void setDataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
        }

        @Override
        public final Builder dataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
            return this;
        }

        public final String getDataProviderArn() {
            return this.dataProviderArn;
        }

        public final void setDataProviderArn(String dataProviderArn) {
            this.dataProviderArn = dataProviderArn;
        }

        @Override
        public final Builder dataProviderArn(String dataProviderArn) {
            this.dataProviderArn = dataProviderArn;
            return this;
        }

        public DataProviderDescriptor build() {
            return new DataProviderDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProviderDescriptor> {
        public Builder secretsManagerSecretId(String var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder dataProviderName(String var1);

        public Builder dataProviderArn(String var1);
    }
}

