/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataMigrationStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataMigrationStatistics> {
    private static final SdkField<Integer> TABLES_LOADED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesLoaded").getter(DataMigrationStatistics.getter(DataMigrationStatistics::tablesLoaded)).setter(DataMigrationStatistics.setter(Builder::tablesLoaded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoaded").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ElapsedTimeMillis").getter(DataMigrationStatistics.getter(DataMigrationStatistics::elapsedTimeMillis)).setter(DataMigrationStatistics.setter(Builder::elapsedTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeMillis").build()}).build();
    private static final SdkField<Integer> TABLES_LOADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesLoading").getter(DataMigrationStatistics.getter(DataMigrationStatistics::tablesLoading)).setter(DataMigrationStatistics.setter(Builder::tablesLoading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoading").build()}).build();
    private static final SdkField<Integer> FULL_LOAD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FullLoadPercentage").getter(DataMigrationStatistics.getter(DataMigrationStatistics::fullLoadPercentage)).setter(DataMigrationStatistics.setter(Builder::fullLoadPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadPercentage").build()}).build();
    private static final SdkField<Integer> CDC_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CDCLatency").getter(DataMigrationStatistics.getter(DataMigrationStatistics::cdcLatency)).setter(DataMigrationStatistics.setter(Builder::cdcLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCLatency").build()}).build();
    private static final SdkField<Integer> TABLES_QUEUED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesQueued").getter(DataMigrationStatistics.getter(DataMigrationStatistics::tablesQueued)).setter(DataMigrationStatistics.setter(Builder::tablesQueued)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesQueued").build()}).build();
    private static final SdkField<Integer> TABLES_ERRORED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesErrored").getter(DataMigrationStatistics.getter(DataMigrationStatistics::tablesErrored)).setter(DataMigrationStatistics.setter(Builder::tablesErrored)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesErrored").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DataMigrationStatistics.getter(DataMigrationStatistics::startTime)).setter(DataMigrationStatistics.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StopTime").getter(DataMigrationStatistics.getter(DataMigrationStatistics::stopTime)).setter(DataMigrationStatistics.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_LOADED_FIELD, ELAPSED_TIME_MILLIS_FIELD, TABLES_LOADING_FIELD, FULL_LOAD_PERCENTAGE_FIELD, CDC_LATENCY_FIELD, TABLES_QUEUED_FIELD, TABLES_ERRORED_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataMigrationStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer tablesLoaded;
    private final Long elapsedTimeMillis;
    private final Integer tablesLoading;
    private final Integer fullLoadPercentage;
    private final Integer cdcLatency;
    private final Integer tablesQueued;
    private final Integer tablesErrored;
    private final Instant startTime;
    private final Instant stopTime;

    private DataMigrationStatistics(BuilderImpl builder) {
        this.tablesLoaded = builder.tablesLoaded;
        this.elapsedTimeMillis = builder.elapsedTimeMillis;
        this.tablesLoading = builder.tablesLoading;
        this.fullLoadPercentage = builder.fullLoadPercentage;
        this.cdcLatency = builder.cdcLatency;
        this.tablesQueued = builder.tablesQueued;
        this.tablesErrored = builder.tablesErrored;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    public final Integer tablesLoaded() {
        return this.tablesLoaded;
    }

    public final Long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public final Integer tablesLoading() {
        return this.tablesLoading;
    }

    public final Integer fullLoadPercentage() {
        return this.fullLoadPercentage;
    }

    public final Integer cdcLatency() {
        return this.cdcLatency;
    }

    public final Integer tablesQueued() {
        return this.tablesQueued;
    }

    public final Integer tablesErrored() {
        return this.tablesErrored;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoading());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesQueued());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesErrored());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataMigrationStatistics)) {
            return false;
        }
        DataMigrationStatistics other = (DataMigrationStatistics)obj;
        return Objects.equals(this.tablesLoaded(), other.tablesLoaded()) && Objects.equals(this.elapsedTimeMillis(), other.elapsedTimeMillis()) && Objects.equals(this.tablesLoading(), other.tablesLoading()) && Objects.equals(this.fullLoadPercentage(), other.fullLoadPercentage()) && Objects.equals(this.cdcLatency(), other.cdcLatency()) && Objects.equals(this.tablesQueued(), other.tablesQueued()) && Objects.equals(this.tablesErrored(), other.tablesErrored()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime());
    }

    public final String toString() {
        return ToString.builder((String)"DataMigrationStatistics").add("TablesLoaded", (Object)this.tablesLoaded()).add("ElapsedTimeMillis", (Object)this.elapsedTimeMillis()).add("TablesLoading", (Object)this.tablesLoading()).add("FullLoadPercentage", (Object)this.fullLoadPercentage()).add("CDCLatency", (Object)this.cdcLatency()).add("TablesQueued", (Object)this.tablesQueued()).add("TablesErrored", (Object)this.tablesErrored()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TablesLoaded": {
                return Optional.ofNullable(clazz.cast(this.tablesLoaded()));
            }
            case "ElapsedTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeMillis()));
            }
            case "TablesLoading": {
                return Optional.ofNullable(clazz.cast(this.tablesLoading()));
            }
            case "FullLoadPercentage": {
                return Optional.ofNullable(clazz.cast(this.fullLoadPercentage()));
            }
            case "CDCLatency": {
                return Optional.ofNullable(clazz.cast(this.cdcLatency()));
            }
            case "TablesQueued": {
                return Optional.ofNullable(clazz.cast(this.tablesQueued()));
            }
            case "TablesErrored": {
                return Optional.ofNullable(clazz.cast(this.tablesErrored()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "StopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TablesLoaded", TABLES_LOADED_FIELD);
        map.put("ElapsedTimeMillis", ELAPSED_TIME_MILLIS_FIELD);
        map.put("TablesLoading", TABLES_LOADING_FIELD);
        map.put("FullLoadPercentage", FULL_LOAD_PERCENTAGE_FIELD);
        map.put("CDCLatency", CDC_LATENCY_FIELD);
        map.put("TablesQueued", TABLES_QUEUED_FIELD);
        map.put("TablesErrored", TABLES_ERRORED_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("StopTime", STOP_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataMigrationStatistics, T> g) {
        return obj -> g.apply((DataMigrationStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer tablesLoaded;
        private Long elapsedTimeMillis;
        private Integer tablesLoading;
        private Integer fullLoadPercentage;
        private Integer cdcLatency;
        private Integer tablesQueued;
        private Integer tablesErrored;
        private Instant startTime;
        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DataMigrationStatistics model) {
            this.tablesLoaded(model.tablesLoaded);
            this.elapsedTimeMillis(model.elapsedTimeMillis);
            this.tablesLoading(model.tablesLoading);
            this.fullLoadPercentage(model.fullLoadPercentage);
            this.cdcLatency(model.cdcLatency);
            this.tablesQueued(model.tablesQueued);
            this.tablesErrored(model.tablesErrored);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
        }

        public final Integer getTablesLoaded() {
            return this.tablesLoaded;
        }

        public final void setTablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
        }

        @Override
        public final Builder tablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
            return this;
        }

        public final Long getElapsedTimeMillis() {
            return this.elapsedTimeMillis;
        }

        public final void setElapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
        }

        @Override
        public final Builder elapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public final Integer getTablesLoading() {
            return this.tablesLoading;
        }

        public final void setTablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
        }

        @Override
        public final Builder tablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
            return this;
        }

        public final Integer getFullLoadPercentage() {
            return this.fullLoadPercentage;
        }

        public final void setFullLoadPercentage(Integer fullLoadPercentage) {
            this.fullLoadPercentage = fullLoadPercentage;
        }

        @Override
        public final Builder fullLoadPercentage(Integer fullLoadPercentage) {
            this.fullLoadPercentage = fullLoadPercentage;
            return this;
        }

        public final Integer getCdcLatency() {
            return this.cdcLatency;
        }

        public final void setCdcLatency(Integer cdcLatency) {
            this.cdcLatency = cdcLatency;
        }

        @Override
        public final Builder cdcLatency(Integer cdcLatency) {
            this.cdcLatency = cdcLatency;
            return this;
        }

        public final Integer getTablesQueued() {
            return this.tablesQueued;
        }

        public final void setTablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
        }

        @Override
        public final Builder tablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
            return this;
        }

        public final Integer getTablesErrored() {
            return this.tablesErrored;
        }

        public final void setTablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
        }

        @Override
        public final Builder tablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public DataMigrationStatistics build() {
            return new DataMigrationStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataMigrationStatistics> {
        public Builder tablesLoaded(Integer var1);

        public Builder elapsedTimeMillis(Long var1);

        public Builder tablesLoading(Integer var1);

        public Builder fullLoadPercentage(Integer var1);

        public Builder cdcLatency(Integer var1);

        public Builder tablesQueued(Integer var1);

        public Builder tablesErrored(Integer var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);
    }
}

