/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.AvailableUpgradesListCopier;
import software.amazon.awssdk.services.databasemigration.model.ReleaseStatusValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineVersion> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(EngineVersion.getter(EngineVersion::version)).setter(EngineVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(EngineVersion.getter(EngineVersion::lifecycle)).setter(EngineVersion.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> RELEASE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseStatus").getter(EngineVersion.getter(EngineVersion::releaseStatusAsString)).setter(EngineVersion.setter(Builder::releaseStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseStatus").build()}).build();
    private static final SdkField<Instant> LAUNCH_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchDate").getter(EngineVersion.getter(EngineVersion::launchDate)).setter(EngineVersion.setter(Builder::launchDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchDate").build()}).build();
    private static final SdkField<Instant> AUTO_UPGRADE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AutoUpgradeDate").getter(EngineVersion.getter(EngineVersion::autoUpgradeDate)).setter(EngineVersion.setter(Builder::autoUpgradeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpgradeDate").build()}).build();
    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeprecationDate").getter(EngineVersion.getter(EngineVersion::deprecationDate)).setter(EngineVersion.setter(Builder::deprecationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationDate").build()}).build();
    private static final SdkField<Instant> FORCE_UPGRADE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ForceUpgradeDate").getter(EngineVersion.getter(EngineVersion::forceUpgradeDate)).setter(EngineVersion.setter(Builder::forceUpgradeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceUpgradeDate").build()}).build();
    private static final SdkField<List<String>> AVAILABLE_UPGRADES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableUpgrades").getter(EngineVersion.getter(EngineVersion::availableUpgrades)).setter(EngineVersion.setter(Builder::availableUpgrades)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableUpgrades").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, LIFECYCLE_FIELD, RELEASE_STATUS_FIELD, LAUNCH_DATE_FIELD, AUTO_UPGRADE_DATE_FIELD, DEPRECATION_DATE_FIELD, FORCE_UPGRADE_DATE_FIELD, AVAILABLE_UPGRADES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EngineVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String lifecycle;
    private final String releaseStatus;
    private final Instant launchDate;
    private final Instant autoUpgradeDate;
    private final Instant deprecationDate;
    private final Instant forceUpgradeDate;
    private final List<String> availableUpgrades;

    private EngineVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.lifecycle = builder.lifecycle;
        this.releaseStatus = builder.releaseStatus;
        this.launchDate = builder.launchDate;
        this.autoUpgradeDate = builder.autoUpgradeDate;
        this.deprecationDate = builder.deprecationDate;
        this.forceUpgradeDate = builder.forceUpgradeDate;
        this.availableUpgrades = builder.availableUpgrades;
    }

    public final String version() {
        return this.version;
    }

    public final String lifecycle() {
        return this.lifecycle;
    }

    public final ReleaseStatusValues releaseStatus() {
        return ReleaseStatusValues.fromValue(this.releaseStatus);
    }

    public final String releaseStatusAsString() {
        return this.releaseStatus;
    }

    public final Instant launchDate() {
        return this.launchDate;
    }

    public final Instant autoUpgradeDate() {
        return this.autoUpgradeDate;
    }

    public final Instant deprecationDate() {
        return this.deprecationDate;
    }

    public final Instant forceUpgradeDate() {
        return this.forceUpgradeDate;
    }

    public final boolean hasAvailableUpgrades() {
        return this.availableUpgrades != null && !(this.availableUpgrades instanceof SdkAutoConstructList);
    }

    public final List<String> availableUpgrades() {
        return this.availableUpgrades;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpgradeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceUpgradeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableUpgrades() ? this.availableUpgrades() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersion)) {
            return false;
        }
        EngineVersion other = (EngineVersion)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.lifecycle(), other.lifecycle()) && Objects.equals(this.releaseStatusAsString(), other.releaseStatusAsString()) && Objects.equals(this.launchDate(), other.launchDate()) && Objects.equals(this.autoUpgradeDate(), other.autoUpgradeDate()) && Objects.equals(this.deprecationDate(), other.deprecationDate()) && Objects.equals(this.forceUpgradeDate(), other.forceUpgradeDate()) && this.hasAvailableUpgrades() == other.hasAvailableUpgrades() && Objects.equals(this.availableUpgrades(), other.availableUpgrades());
    }

    public final String toString() {
        return ToString.builder((String)"EngineVersion").add("Version", (Object)this.version()).add("Lifecycle", (Object)this.lifecycle()).add("ReleaseStatus", (Object)this.releaseStatusAsString()).add("LaunchDate", (Object)this.launchDate()).add("AutoUpgradeDate", (Object)this.autoUpgradeDate()).add("DeprecationDate", (Object)this.deprecationDate()).add("ForceUpgradeDate", (Object)this.forceUpgradeDate()).add("AvailableUpgrades", this.hasAvailableUpgrades() ? this.availableUpgrades() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "ReleaseStatus": {
                return Optional.ofNullable(clazz.cast(this.releaseStatusAsString()));
            }
            case "LaunchDate": {
                return Optional.ofNullable(clazz.cast(this.launchDate()));
            }
            case "AutoUpgradeDate": {
                return Optional.ofNullable(clazz.cast(this.autoUpgradeDate()));
            }
            case "DeprecationDate": {
                return Optional.ofNullable(clazz.cast(this.deprecationDate()));
            }
            case "ForceUpgradeDate": {
                return Optional.ofNullable(clazz.cast(this.forceUpgradeDate()));
            }
            case "AvailableUpgrades": {
                return Optional.ofNullable(clazz.cast(this.availableUpgrades()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Version", VERSION_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("ReleaseStatus", RELEASE_STATUS_FIELD);
        map.put("LaunchDate", LAUNCH_DATE_FIELD);
        map.put("AutoUpgradeDate", AUTO_UPGRADE_DATE_FIELD);
        map.put("DeprecationDate", DEPRECATION_DATE_FIELD);
        map.put("ForceUpgradeDate", FORCE_UPGRADE_DATE_FIELD);
        map.put("AvailableUpgrades", AVAILABLE_UPGRADES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngineVersion, T> g) {
        return obj -> g.apply((EngineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String lifecycle;
        private String releaseStatus;
        private Instant launchDate;
        private Instant autoUpgradeDate;
        private Instant deprecationDate;
        private Instant forceUpgradeDate;
        private List<String> availableUpgrades = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngineVersion model) {
            this.version(model.version);
            this.lifecycle(model.lifecycle);
            this.releaseStatus(model.releaseStatus);
            this.launchDate(model.launchDate);
            this.autoUpgradeDate(model.autoUpgradeDate);
            this.deprecationDate(model.deprecationDate);
            this.forceUpgradeDate(model.forceUpgradeDate);
            this.availableUpgrades(model.availableUpgrades);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final String getReleaseStatus() {
            return this.releaseStatus;
        }

        public final void setReleaseStatus(String releaseStatus) {
            this.releaseStatus = releaseStatus;
        }

        @Override
        public final Builder releaseStatus(String releaseStatus) {
            this.releaseStatus = releaseStatus;
            return this;
        }

        @Override
        public final Builder releaseStatus(ReleaseStatusValues releaseStatus) {
            this.releaseStatus(releaseStatus == null ? null : releaseStatus.toString());
            return this;
        }

        public final Instant getLaunchDate() {
            return this.launchDate;
        }

        public final void setLaunchDate(Instant launchDate) {
            this.launchDate = launchDate;
        }

        @Override
        public final Builder launchDate(Instant launchDate) {
            this.launchDate = launchDate;
            return this;
        }

        public final Instant getAutoUpgradeDate() {
            return this.autoUpgradeDate;
        }

        public final void setAutoUpgradeDate(Instant autoUpgradeDate) {
            this.autoUpgradeDate = autoUpgradeDate;
        }

        @Override
        public final Builder autoUpgradeDate(Instant autoUpgradeDate) {
            this.autoUpgradeDate = autoUpgradeDate;
            return this;
        }

        public final Instant getDeprecationDate() {
            return this.deprecationDate;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final Instant getForceUpgradeDate() {
            return this.forceUpgradeDate;
        }

        public final void setForceUpgradeDate(Instant forceUpgradeDate) {
            this.forceUpgradeDate = forceUpgradeDate;
        }

        @Override
        public final Builder forceUpgradeDate(Instant forceUpgradeDate) {
            this.forceUpgradeDate = forceUpgradeDate;
            return this;
        }

        public final Collection<String> getAvailableUpgrades() {
            if (this.availableUpgrades instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availableUpgrades;
        }

        public final void setAvailableUpgrades(Collection<String> availableUpgrades) {
            this.availableUpgrades = AvailableUpgradesListCopier.copy(availableUpgrades);
        }

        @Override
        public final Builder availableUpgrades(Collection<String> availableUpgrades) {
            this.availableUpgrades = AvailableUpgradesListCopier.copy(availableUpgrades);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableUpgrades(String ... availableUpgrades) {
            this.availableUpgrades(Arrays.asList(availableUpgrades));
            return this;
        }

        public EngineVersion build() {
            return new EngineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineVersion> {
        public Builder version(String var1);

        public Builder lifecycle(String var1);

        public Builder releaseStatus(String var1);

        public Builder releaseStatus(ReleaseStatusValues var1);

        public Builder launchDate(Instant var1);

        public Builder autoUpgradeDate(Instant var1);

        public Builder deprecationDate(Instant var1);

        public Builder forceUpgradeDate(Instant var1);

        public Builder availableUpgrades(Collection<String> var1);

        public Builder availableUpgrades(String ... var1);
    }
}

