/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;

public class DescribeSchemasPublisher
implements SdkPublisher<DescribeSchemasResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeSchemasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSchemasPublisher(DatabaseMigrationAsyncClient client, DescribeSchemasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSchemasPublisher(DatabaseMigrationAsyncClient client, DescribeSchemasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSchemasResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSchemasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeSchemasResponseFetcher
    implements AsyncPageFetcher<DescribeSchemasResponse> {
        private DescribeSchemasResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeSchemasResponse> nextPage(DescribeSchemasResponse previousPage) {
            if (previousPage == null) {
                return DescribeSchemasPublisher.this.client.describeSchemas(DescribeSchemasPublisher.this.firstRequest);
            }
            return DescribeSchemasPublisher.this.client.describeSchemas((DescribeSchemasRequest)((Object)DescribeSchemasPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

