/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse;

public class DescribeMigrationProjectsIterable
implements SdkIterable<DescribeMigrationProjectsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeMigrationProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMigrationProjectsIterable(DatabaseMigrationClient client, DescribeMigrationProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMigrationProjectsResponseFetcher();
    }

    public Iterator<DescribeMigrationProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeMigrationProjectsResponseFetcher
    implements SyncPageFetcher<DescribeMigrationProjectsResponse> {
        private DescribeMigrationProjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMigrationProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeMigrationProjectsResponse nextPage(DescribeMigrationProjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMigrationProjectsIterable.this.client.describeMigrationProjects(DescribeMigrationProjectsIterable.this.firstRequest);
            }
            return DescribeMigrationProjectsIterable.this.client.describeMigrationProjects((DescribeMigrationProjectsRequest)((Object)DescribeMigrationProjectsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

