/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse;

public class DescribeMetadataModelConversionsIterable
implements SdkIterable<DescribeMetadataModelConversionsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeMetadataModelConversionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMetadataModelConversionsIterable(DatabaseMigrationClient client, DescribeMetadataModelConversionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMetadataModelConversionsResponseFetcher();
    }

    public Iterator<DescribeMetadataModelConversionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeMetadataModelConversionsResponseFetcher
    implements SyncPageFetcher<DescribeMetadataModelConversionsResponse> {
        private DescribeMetadataModelConversionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelConversionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeMetadataModelConversionsResponse nextPage(DescribeMetadataModelConversionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelConversionsIterable.this.client.describeMetadataModelConversions(DescribeMetadataModelConversionsIterable.this.firstRequest);
            }
            return DescribeMetadataModelConversionsIterable.this.client.describeMetadataModelConversions((DescribeMetadataModelConversionsRequest)((Object)DescribeMetadataModelConversionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

