/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse;

public class DescribeInstanceProfilesPublisher
implements SdkPublisher<DescribeInstanceProfilesResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeInstanceProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceProfilesPublisher(DatabaseMigrationAsyncClient client, DescribeInstanceProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceProfilesPublisher(DatabaseMigrationAsyncClient client, DescribeInstanceProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeInstanceProfilesResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceProfilesResponse> {
        private DescribeInstanceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeInstanceProfilesResponse> nextPage(DescribeInstanceProfilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceProfilesPublisher.this.client.describeInstanceProfiles(DescribeInstanceProfilesPublisher.this.firstRequest);
            }
            return DescribeInstanceProfilesPublisher.this.client.describeInstanceProfiles((DescribeInstanceProfilesRequest)((Object)DescribeInstanceProfilesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

