/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;

public class DescribeEndpointsIterable
implements SdkIterable<DescribeEndpointsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointsIterable(DatabaseMigrationClient client, DescribeEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEndpointsResponseFetcher();
    }

    public Iterator<DescribeEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeEndpointsResponse> {
        private DescribeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEndpointsResponse nextPage(DescribeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointsIterable.this.client.describeEndpoints(DescribeEndpointsIterable.this.firstRequest);
            }
            return DescribeEndpointsIterable.this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

