/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TlogAccessMode {
    BACKUP_ONLY("BackupOnly"),
    PREFER_BACKUP("PreferBackup"),
    PREFER_TLOG("PreferTlog"),
    TLOG_ONLY("TlogOnly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TlogAccessMode> VALUE_MAP;
    private final String value;

    private TlogAccessMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TlogAccessMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TlogAccessMode> knownValues() {
        EnumSet<TlogAccessMode> knownValues = EnumSet.allOf(TlogAccessMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TlogAccessMode.class, TlogAccessMode::toString);
    }
}

