/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.LayoutType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainLayoutRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, UpdateDomainLayoutRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::domainName)).setter(UpdateDomainLayoutRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> LAYOUT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayoutDefinitionName").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::layoutDefinitionName)).setter(UpdateDomainLayoutRequest.setter(Builder::layoutDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayoutDefinitionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::description)).setter(UpdateDomainLayoutRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::displayName)).setter(UpdateDomainLayoutRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::isDefault)).setter(UpdateDomainLayoutRequest.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> LAYOUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayoutType").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::layoutTypeAsString)).setter(UpdateDomainLayoutRequest.setter(Builder::layoutType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayoutType").build()}).build();
    private static final SdkField<String> LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Layout").getter(UpdateDomainLayoutRequest.getter(UpdateDomainLayoutRequest::layout)).setter(UpdateDomainLayoutRequest.setter(Builder::layout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, LAYOUT_DEFINITION_NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IS_DEFAULT_FIELD, LAYOUT_TYPE_FIELD, LAYOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDomainLayoutRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String layoutDefinitionName;
    private final String description;
    private final String displayName;
    private final Boolean isDefault;
    private final String layoutType;
    private final String layout;

    private UpdateDomainLayoutRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.layoutDefinitionName = builder.layoutDefinitionName;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.isDefault = builder.isDefault;
        this.layoutType = builder.layoutType;
        this.layout = builder.layout;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String layoutDefinitionName() {
        return this.layoutDefinitionName;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final LayoutType layoutType() {
        return LayoutType.fromValue(this.layoutType);
    }

    public final String layoutTypeAsString() {
        return this.layoutType;
    }

    public final String layout() {
        return this.layout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.layout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainLayoutRequest)) {
            return false;
        }
        UpdateDomainLayoutRequest other = (UpdateDomainLayoutRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.layoutDefinitionName(), other.layoutDefinitionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.layoutTypeAsString(), other.layoutTypeAsString()) && Objects.equals(this.layout(), other.layout());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainLayoutRequest").add("DomainName", (Object)this.domainName()).add("LayoutDefinitionName", (Object)this.layoutDefinitionName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)this.displayName()).add("IsDefault", (Object)this.isDefault()).add("LayoutType", (Object)this.layoutTypeAsString()).add("Layout", (Object)(this.layout() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "LayoutDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.layoutDefinitionName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "LayoutType": {
                return Optional.ofNullable(clazz.cast(this.layoutTypeAsString()));
            }
            case "Layout": {
                return Optional.ofNullable(clazz.cast(this.layout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("LayoutDefinitionName", LAYOUT_DEFINITION_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("LayoutType", LAYOUT_TYPE_FIELD);
        map.put("Layout", LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainLayoutRequest, T> g) {
        return obj -> g.apply((UpdateDomainLayoutRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String layoutDefinitionName;
        private String description;
        private String displayName;
        private Boolean isDefault;
        private String layoutType;
        private String layout;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainLayoutRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.layoutDefinitionName(model.layoutDefinitionName);
            this.description(model.description);
            this.displayName(model.displayName);
            this.isDefault(model.isDefault);
            this.layoutType(model.layoutType);
            this.layout(model.layout);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getLayoutDefinitionName() {
            return this.layoutDefinitionName;
        }

        public final void setLayoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
        }

        @Override
        public final Builder layoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getLayoutType() {
            return this.layoutType;
        }

        public final void setLayoutType(String layoutType) {
            this.layoutType = layoutType;
        }

        @Override
        public final Builder layoutType(String layoutType) {
            this.layoutType = layoutType;
            return this;
        }

        @Override
        public final Builder layoutType(LayoutType layoutType) {
            this.layoutType(layoutType == null ? null : layoutType.toString());
            return this;
        }

        public final String getLayout() {
            return this.layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainLayoutRequest build() {
            return new UpdateDomainLayoutRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainLayoutRequest> {
        public Builder domainName(String var1);

        public Builder layoutDefinitionName(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder isDefault(Boolean var1);

        public Builder layoutType(String var1);

        public Builder layoutType(LayoutType var1);

        public Builder layout(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

