/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.MatchingRuleAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchingRule> {
    private static final SdkField<List<String>> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rule").getter(MatchingRule.getter(MatchingRule::rule)).setter(MatchingRule.setter(Builder::rule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MatchingRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> rule;

    private MatchingRule(BuilderImpl builder) {
        this.rule = builder.rule;
    }

    public final boolean hasRule() {
        return this.rule != null && !(this.rule instanceof SdkAutoConstructList);
    }

    public final List<String> rule() {
        return this.rule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRule() ? this.rule() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingRule)) {
            return false;
        }
        MatchingRule other = (MatchingRule)obj;
        return this.hasRule() == other.hasRule() && Objects.equals(this.rule(), other.rule());
    }

    public final String toString() {
        return ToString.builder((String)"MatchingRule").add("Rule", this.hasRule() ? this.rule() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchingRule, T> g) {
        return obj -> g.apply((MatchingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> rule = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingRule model) {
            this.rule(model.rule);
        }

        public final Collection<String> getRule() {
            if (this.rule instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rule;
        }

        public final void setRule(Collection<String> rule) {
            this.rule = MatchingRuleAttributeListCopier.copy(rule);
        }

        @Override
        public final Builder rule(Collection<String> rule) {
            this.rule = MatchingRuleAttributeListCopier.copy(rule);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rule(String ... rule) {
            this.rule(Arrays.asList(rule));
            return this;
        }

        public MatchingRule build() {
            return new MatchingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchingRule> {
        public Builder rule(Collection<String> var1);

        public Builder rule(String ... var1);
    }
}

