/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.StatusReason;
import software.amazon.awssdk.services.customerprofiles.model.UploadJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadJobItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UploadJobItem> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(UploadJobItem.getter(UploadJobItem::jobId)).setter(UploadJobItem.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UploadJobItem.getter(UploadJobItem::displayName)).setter(UploadJobItem.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UploadJobItem.getter(UploadJobItem::statusAsString)).setter(UploadJobItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(UploadJobItem.getter(UploadJobItem::statusReasonAsString)).setter(UploadJobItem.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(UploadJobItem.getter(UploadJobItem::createdAt)).setter(UploadJobItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedAt").getter(UploadJobItem.getter(UploadJobItem::completedAt)).setter(UploadJobItem.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()}).build();
    private static final SdkField<Integer> DATA_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataExpiry").getter(UploadJobItem.getter(UploadJobItem::dataExpiry)).setter(UploadJobItem.setter(Builder::dataExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExpiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, DATA_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UploadJobItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final Instant createdAt;
    private final Instant completedAt;
    private final Integer dataExpiry;

    private UploadJobItem(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.dataExpiry = builder.dataExpiry;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final UploadJobStatus status() {
        return UploadJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusReason statusReason() {
        return StatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final Integer dataExpiry() {
        return this.dataExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadJobItem)) {
            return false;
        }
        UploadJobItem other = (UploadJobItem)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.dataExpiry(), other.dataExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"UploadJobItem").add("JobId", (Object)this.jobId()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("CreatedAt", (Object)this.createdAt()).add("CompletedAt", (Object)this.completedAt()).add("DataExpiry", (Object)this.dataExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "DataExpiry": {
                return Optional.ofNullable(clazz.cast(this.dataExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CompletedAt", COMPLETED_AT_FIELD);
        map.put("DataExpiry", DATA_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadJobItem, T> g) {
        return obj -> g.apply((UploadJobItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String displayName;
        private String status;
        private String statusReason;
        private Instant createdAt;
        private Instant completedAt;
        private Integer dataExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadJobItem model) {
            this.jobId(model.jobId);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.createdAt(model.createdAt);
            this.completedAt(model.completedAt);
            this.dataExpiry(model.dataExpiry);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UploadJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(StatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Integer getDataExpiry() {
            return this.dataExpiry;
        }

        public final void setDataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
        }

        @Override
        public final Builder dataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
            return this;
        }

        public UploadJobItem build() {
            return new UploadJobItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UploadJobItem> {
        public Builder jobId(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(UploadJobStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(StatusReason var1);

        public Builder createdAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder dataExpiry(Integer var1);
    }
}

