/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerCondition;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerConditionsCopier;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerLimits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventTriggerRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, UpdateEventTriggerRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::domainName)).setter(UpdateEventTriggerRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> EVENT_TRIGGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventTriggerName").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::eventTriggerName)).setter(UpdateEventTriggerRequest.setter(Builder::eventTriggerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EventTriggerName").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::objectTypeName)).setter(UpdateEventTriggerRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::description)).setter(UpdateEventTriggerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<EventTriggerCondition>> EVENT_TRIGGER_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTriggerConditions").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::eventTriggerConditions)).setter(UpdateEventTriggerRequest.setter(Builder::eventTriggerConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTriggerCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEGMENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentFilter").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::segmentFilter)).setter(UpdateEventTriggerRequest.setter(Builder::segmentFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentFilter").build()}).build();
    private static final SdkField<EventTriggerLimits> EVENT_TRIGGER_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventTriggerLimits").getter(UpdateEventTriggerRequest.getter(UpdateEventTriggerRequest::eventTriggerLimits)).setter(UpdateEventTriggerRequest.setter(Builder::eventTriggerLimits)).constructor(EventTriggerLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerLimits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, EVENT_TRIGGER_NAME_FIELD, OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, EVENT_TRIGGER_CONDITIONS_FIELD, SEGMENT_FILTER_FIELD, EVENT_TRIGGER_LIMITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEventTriggerRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String eventTriggerName;
    private final String objectTypeName;
    private final String description;
    private final List<EventTriggerCondition> eventTriggerConditions;
    private final String segmentFilter;
    private final EventTriggerLimits eventTriggerLimits;

    private UpdateEventTriggerRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.eventTriggerName = builder.eventTriggerName;
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.eventTriggerConditions = builder.eventTriggerConditions;
        this.segmentFilter = builder.segmentFilter;
        this.eventTriggerLimits = builder.eventTriggerLimits;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String eventTriggerName() {
        return this.eventTriggerName;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventTriggerConditions() {
        return this.eventTriggerConditions != null && !(this.eventTriggerConditions instanceof SdkAutoConstructList);
    }

    public final List<EventTriggerCondition> eventTriggerConditions() {
        return this.eventTriggerConditions;
    }

    public final String segmentFilter() {
        return this.segmentFilter;
    }

    public final EventTriggerLimits eventTriggerLimits() {
        return this.eventTriggerLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTriggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTriggerConditions() ? this.eventTriggerConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTriggerLimits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventTriggerRequest)) {
            return false;
        }
        UpdateEventTriggerRequest other = (UpdateEventTriggerRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.eventTriggerName(), other.eventTriggerName()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.description(), other.description()) && this.hasEventTriggerConditions() == other.hasEventTriggerConditions() && Objects.equals(this.eventTriggerConditions(), other.eventTriggerConditions()) && Objects.equals(this.segmentFilter(), other.segmentFilter()) && Objects.equals(this.eventTriggerLimits(), other.eventTriggerLimits());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventTriggerRequest").add("DomainName", (Object)this.domainName()).add("EventTriggerName", (Object)this.eventTriggerName()).add("ObjectTypeName", (Object)this.objectTypeName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTriggerConditions", (Object)(this.eventTriggerConditions() == null ? null : "*** Sensitive Data Redacted ***")).add("SegmentFilter", (Object)this.segmentFilter()).add("EventTriggerLimits", (Object)this.eventTriggerLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EventTriggerName": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerName()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventTriggerConditions": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerConditions()));
            }
            case "SegmentFilter": {
                return Optional.ofNullable(clazz.cast(this.segmentFilter()));
            }
            case "EventTriggerLimits": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerLimits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EventTriggerName", EVENT_TRIGGER_NAME_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EventTriggerConditions", EVENT_TRIGGER_CONDITIONS_FIELD);
        map.put("SegmentFilter", SEGMENT_FILTER_FIELD);
        map.put("EventTriggerLimits", EVENT_TRIGGER_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventTriggerRequest, T> g) {
        return obj -> g.apply((UpdateEventTriggerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String eventTriggerName;
        private String objectTypeName;
        private String description;
        private List<EventTriggerCondition> eventTriggerConditions = DefaultSdkAutoConstructList.getInstance();
        private String segmentFilter;
        private EventTriggerLimits eventTriggerLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventTriggerRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.eventTriggerName(model.eventTriggerName);
            this.objectTypeName(model.objectTypeName);
            this.description(model.description);
            this.eventTriggerConditions(model.eventTriggerConditions);
            this.segmentFilter(model.segmentFilter);
            this.eventTriggerLimits(model.eventTriggerLimits);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEventTriggerName() {
            return this.eventTriggerName;
        }

        public final void setEventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
        }

        @Override
        public final Builder eventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventTriggerCondition.Builder> getEventTriggerConditions() {
            List<EventTriggerCondition.Builder> result = EventTriggerConditionsCopier.copyToBuilder(this.eventTriggerConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTriggerConditions(Collection<EventTriggerCondition.BuilderImpl> eventTriggerConditions) {
            this.eventTriggerConditions = EventTriggerConditionsCopier.copyFromBuilder(eventTriggerConditions);
        }

        @Override
        public final Builder eventTriggerConditions(Collection<EventTriggerCondition> eventTriggerConditions) {
            this.eventTriggerConditions = EventTriggerConditionsCopier.copy(eventTriggerConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerConditions(EventTriggerCondition ... eventTriggerConditions) {
            this.eventTriggerConditions(Arrays.asList(eventTriggerConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerConditions(Consumer<EventTriggerCondition.Builder> ... eventTriggerConditions) {
            this.eventTriggerConditions(Stream.of(eventTriggerConditions).map(c -> (EventTriggerCondition)((EventTriggerCondition.Builder)EventTriggerCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSegmentFilter() {
            return this.segmentFilter;
        }

        public final void setSegmentFilter(String segmentFilter) {
            this.segmentFilter = segmentFilter;
        }

        @Override
        public final Builder segmentFilter(String segmentFilter) {
            this.segmentFilter = segmentFilter;
            return this;
        }

        public final EventTriggerLimits.Builder getEventTriggerLimits() {
            return this.eventTriggerLimits != null ? this.eventTriggerLimits.toBuilder() : null;
        }

        public final void setEventTriggerLimits(EventTriggerLimits.BuilderImpl eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits != null ? eventTriggerLimits.build() : null;
        }

        @Override
        public final Builder eventTriggerLimits(EventTriggerLimits eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventTriggerRequest build() {
            return new UpdateEventTriggerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventTriggerRequest> {
        public Builder domainName(String var1);

        public Builder eventTriggerName(String var1);

        public Builder objectTypeName(String var1);

        public Builder description(String var1);

        public Builder eventTriggerConditions(Collection<EventTriggerCondition> var1);

        public Builder eventTriggerConditions(EventTriggerCondition ... var1);

        public Builder eventTriggerConditions(Consumer<EventTriggerCondition.Builder> ... var1);

        public Builder segmentFilter(String var1);

        public Builder eventTriggerLimits(EventTriggerLimits var1);

        default public Builder eventTriggerLimits(Consumer<EventTriggerLimits.Builder> eventTriggerLimits) {
            return this.eventTriggerLimits((EventTriggerLimits)((EventTriggerLimits.Builder)EventTriggerLimits.builder().applyMutation(eventTriggerLimits)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

