/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.ActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileHistoryRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileHistoryRecord> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::id)).setter(ProfileHistoryRecord.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::objectTypeName)).setter(ProfileHistoryRecord.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::createdAt)).setter(ProfileHistoryRecord.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::lastUpdatedAt)).setter(ProfileHistoryRecord.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::actionTypeAsString)).setter(ProfileHistoryRecord.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> PROFILE_OBJECT_UNIQUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileObjectUniqueKey").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::profileObjectUniqueKey)).setter(ProfileHistoryRecord.setter(Builder::profileObjectUniqueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileObjectUniqueKey").build()}).build();
    private static final SdkField<String> PERFORMED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformedBy").getter(ProfileHistoryRecord.getter(ProfileHistoryRecord::performedBy)).setter(ProfileHistoryRecord.setter(Builder::performedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, OBJECT_TYPE_NAME_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ACTION_TYPE_FIELD, PROFILE_OBJECT_UNIQUE_KEY_FIELD, PERFORMED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProfileHistoryRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String objectTypeName;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String actionType;
    private final String profileObjectUniqueKey;
    private final String performedBy;

    private ProfileHistoryRecord(BuilderImpl builder) {
        this.id = builder.id;
        this.objectTypeName = builder.objectTypeName;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.actionType = builder.actionType;
        this.profileObjectUniqueKey = builder.profileObjectUniqueKey;
        this.performedBy = builder.performedBy;
    }

    public final String id() {
        return this.id;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String profileObjectUniqueKey() {
        return this.profileObjectUniqueKey;
    }

    public final String performedBy() {
        return this.performedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileObjectUniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.performedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileHistoryRecord)) {
            return false;
        }
        ProfileHistoryRecord other = (ProfileHistoryRecord)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.profileObjectUniqueKey(), other.profileObjectUniqueKey()) && Objects.equals(this.performedBy(), other.performedBy());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileHistoryRecord").add("Id", (Object)this.id()).add("ObjectTypeName", (Object)this.objectTypeName()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ActionType", (Object)this.actionTypeAsString()).add("ProfileObjectUniqueKey", (Object)this.profileObjectUniqueKey()).add("PerformedBy", (Object)this.performedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ProfileObjectUniqueKey": {
                return Optional.ofNullable(clazz.cast(this.profileObjectUniqueKey()));
            }
            case "PerformedBy": {
                return Optional.ofNullable(clazz.cast(this.performedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("ProfileObjectUniqueKey", PROFILE_OBJECT_UNIQUE_KEY_FIELD);
        map.put("PerformedBy", PERFORMED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileHistoryRecord, T> g) {
        return obj -> g.apply((ProfileHistoryRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String objectTypeName;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String actionType;
        private String profileObjectUniqueKey;
        private String performedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileHistoryRecord model) {
            this.id(model.id);
            this.objectTypeName(model.objectTypeName);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.actionType(model.actionType);
            this.profileObjectUniqueKey(model.profileObjectUniqueKey);
            this.performedBy(model.performedBy);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getProfileObjectUniqueKey() {
            return this.profileObjectUniqueKey;
        }

        public final void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
        }

        @Override
        public final Builder profileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
            return this;
        }

        public final String getPerformedBy() {
            return this.performedBy;
        }

        public final void setPerformedBy(String performedBy) {
            this.performedBy = performedBy;
        }

        @Override
        public final Builder performedBy(String performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        public ProfileHistoryRecord build() {
            return new ProfileHistoryRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileHistoryRecord> {
        public Builder id(String var1);

        public Builder objectTypeName(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder profileObjectUniqueKey(String var1);

        public Builder performedBy(String var1);
    }
}

