/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ProfileHistoryRecord;
import software.amazon.awssdk.services.customerprofiles.model.ProfileHistoryRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileHistoryRecordsResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, ListProfileHistoryRecordsResponse> {
    private static final SdkField<List<ProfileHistoryRecord>> PROFILE_HISTORY_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileHistoryRecords").getter(ListProfileHistoryRecordsResponse.getter(ListProfileHistoryRecordsResponse::profileHistoryRecords)).setter(ListProfileHistoryRecordsResponse.setter(Builder::profileHistoryRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileHistoryRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileHistoryRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfileHistoryRecordsResponse.getter(ListProfileHistoryRecordsResponse::nextToken)).setter(ListProfileHistoryRecordsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_HISTORY_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProfileHistoryRecordsResponse.memberNameToFieldInitializer();
    private final List<ProfileHistoryRecord> profileHistoryRecords;
    private final String nextToken;

    private ListProfileHistoryRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.profileHistoryRecords = builder.profileHistoryRecords;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProfileHistoryRecords() {
        return this.profileHistoryRecords != null && !(this.profileHistoryRecords instanceof SdkAutoConstructList);
    }

    public final List<ProfileHistoryRecord> profileHistoryRecords() {
        return this.profileHistoryRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileHistoryRecords() ? this.profileHistoryRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileHistoryRecordsResponse)) {
            return false;
        }
        ListProfileHistoryRecordsResponse other = (ListProfileHistoryRecordsResponse)((Object)obj);
        return this.hasProfileHistoryRecords() == other.hasProfileHistoryRecords() && Objects.equals(this.profileHistoryRecords(), other.profileHistoryRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileHistoryRecordsResponse").add("ProfileHistoryRecords", this.hasProfileHistoryRecords() ? this.profileHistoryRecords() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileHistoryRecords": {
                return Optional.ofNullable(clazz.cast(this.profileHistoryRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProfileHistoryRecords", PROFILE_HISTORY_RECORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileHistoryRecordsResponse, T> g) {
        return obj -> g.apply((ListProfileHistoryRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private List<ProfileHistoryRecord> profileHistoryRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileHistoryRecordsResponse model) {
            super(model);
            this.profileHistoryRecords(model.profileHistoryRecords);
            this.nextToken(model.nextToken);
        }

        public final List<ProfileHistoryRecord.Builder> getProfileHistoryRecords() {
            List<ProfileHistoryRecord.Builder> result = ProfileHistoryRecordsCopier.copyToBuilder(this.profileHistoryRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileHistoryRecords(Collection<ProfileHistoryRecord.BuilderImpl> profileHistoryRecords) {
            this.profileHistoryRecords = ProfileHistoryRecordsCopier.copyFromBuilder(profileHistoryRecords);
        }

        @Override
        public final Builder profileHistoryRecords(Collection<ProfileHistoryRecord> profileHistoryRecords) {
            this.profileHistoryRecords = ProfileHistoryRecordsCopier.copy(profileHistoryRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileHistoryRecords(ProfileHistoryRecord ... profileHistoryRecords) {
            this.profileHistoryRecords(Arrays.asList(profileHistoryRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileHistoryRecords(Consumer<ProfileHistoryRecord.Builder> ... profileHistoryRecords) {
            this.profileHistoryRecords(Stream.of(profileHistoryRecords).map(c -> (ProfileHistoryRecord)((ProfileHistoryRecord.Builder)ProfileHistoryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProfileHistoryRecordsResponse build() {
            return new ListProfileHistoryRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileHistoryRecordsResponse> {
        public Builder profileHistoryRecords(Collection<ProfileHistoryRecord> var1);

        public Builder profileHistoryRecords(ProfileHistoryRecord ... var1);

        public Builder profileHistoryRecords(Consumer<ProfileHistoryRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

