/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.Dimension;
import software.amazon.awssdk.services.customerprofiles.model.DimensionListCopier;
import software.amazon.awssdk.services.customerprofiles.model.IncludeOptions;
import software.amazon.awssdk.services.customerprofiles.model.SourceSegment;
import software.amazon.awssdk.services.customerprofiles.model.SourceSegmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Group
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Group> {
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(Group.getter(Group::dimensions)).setter(Group.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SourceSegment>> SOURCE_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceSegments").getter(Group.getter(Group::sourceSegments)).setter(Group.setter(Builder::sourceSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(Group.getter(Group::sourceTypeAsString)).setter(Group.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Group.getter(Group::typeAsString)).setter(Group.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, SOURCE_SEGMENTS_FIELD, SOURCE_TYPE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Group.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Dimension> dimensions;
    private final List<SourceSegment> sourceSegments;
    private final String sourceType;
    private final String type;

    private Group(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.sourceSegments = builder.sourceSegments;
        this.sourceType = builder.sourceType;
        this.type = builder.type;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public final boolean hasSourceSegments() {
        return this.sourceSegments != null && !(this.sourceSegments instanceof SdkAutoConstructList);
    }

    public final List<SourceSegment> sourceSegments() {
        return this.sourceSegments;
    }

    public final IncludeOptions sourceType() {
        return IncludeOptions.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final IncludeOptions type() {
        return IncludeOptions.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceSegments() ? this.sourceSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && this.hasSourceSegments() == other.hasSourceSegments() && Objects.equals(this.sourceSegments(), other.sourceSegments()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Group").add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("SourceSegments", this.hasSourceSegments() ? this.sourceSegments() : null).add("SourceType", (Object)this.sourceTypeAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "SourceSegments": {
                return Optional.ofNullable(clazz.cast(this.sourceSegments()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("SourceSegments", SOURCE_SEGMENTS_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private List<SourceSegment> sourceSegments = DefaultSdkAutoConstructList.getInstance();
        private String sourceType;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            this.dimensions(model.dimensions);
            this.sourceSegments(model.sourceSegments);
            this.sourceType(model.sourceType);
            this.type(model.type);
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SourceSegment.Builder> getSourceSegments() {
            List<SourceSegment.Builder> result = SourceSegmentListCopier.copyToBuilder(this.sourceSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceSegments(Collection<SourceSegment.BuilderImpl> sourceSegments) {
            this.sourceSegments = SourceSegmentListCopier.copyFromBuilder(sourceSegments);
        }

        @Override
        public final Builder sourceSegments(Collection<SourceSegment> sourceSegments) {
            this.sourceSegments = SourceSegmentListCopier.copy(sourceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(SourceSegment ... sourceSegments) {
            this.sourceSegments(Arrays.asList(sourceSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(Consumer<SourceSegment.Builder> ... sourceSegments) {
            this.sourceSegments(Stream.of(sourceSegments).map(c -> (SourceSegment)((SourceSegment.Builder)SourceSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(IncludeOptions sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IncludeOptions type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Group build() {
            return new Group(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Group> {
        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder sourceSegments(Collection<SourceSegment> var1);

        public Builder sourceSegments(SourceSegment ... var1);

        public Builder sourceSegments(Consumer<SourceSegment.Builder> ... var1);

        public Builder sourceType(String var1);

        public Builder sourceType(IncludeOptions var1);

        public Builder type(String var1);

        public Builder type(IncludeOptions var1);
    }
}

