/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainLayoutRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, GetDomainLayoutRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetDomainLayoutRequest.getter(GetDomainLayoutRequest::domainName)).setter(GetDomainLayoutRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> LAYOUT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayoutDefinitionName").getter(GetDomainLayoutRequest.getter(GetDomainLayoutRequest::layoutDefinitionName)).setter(GetDomainLayoutRequest.setter(Builder::layoutDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayoutDefinitionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, LAYOUT_DEFINITION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDomainLayoutRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String layoutDefinitionName;

    private GetDomainLayoutRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.layoutDefinitionName = builder.layoutDefinitionName;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String layoutDefinitionName() {
        return this.layoutDefinitionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutDefinitionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainLayoutRequest)) {
            return false;
        }
        GetDomainLayoutRequest other = (GetDomainLayoutRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.layoutDefinitionName(), other.layoutDefinitionName());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainLayoutRequest").add("DomainName", (Object)this.domainName()).add("LayoutDefinitionName", (Object)this.layoutDefinitionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "LayoutDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.layoutDefinitionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("LayoutDefinitionName", LAYOUT_DEFINITION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDomainLayoutRequest, T> g) {
        return obj -> g.apply((GetDomainLayoutRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String layoutDefinitionName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainLayoutRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.layoutDefinitionName(model.layoutDefinitionName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getLayoutDefinitionName() {
            return this.layoutDefinitionName;
        }

        public final void setLayoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
        }

        @Override
        public final Builder layoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDomainLayoutRequest build() {
            return new GetDomainLayoutRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainLayoutRequest> {
        public Builder domainName(String var1);

        public Builder layoutDefinitionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

