/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.FieldMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUploadJobRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateUploadJobRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateUploadJobRequest.getter(CreateUploadJobRequest::domainName)).setter(CreateUploadJobRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateUploadJobRequest.getter(CreateUploadJobRequest::displayName)).setter(CreateUploadJobRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Fields").getter(CreateUploadJobRequest.getter(CreateUploadJobRequest::fields)).setter(CreateUploadJobRequest.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UNIQUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniqueKey").getter(CreateUploadJobRequest.getter(CreateUploadJobRequest::uniqueKey)).setter(CreateUploadJobRequest.setter(Builder::uniqueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKey").build()}).build();
    private static final SdkField<Integer> DATA_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataExpiry").getter(CreateUploadJobRequest.getter(CreateUploadJobRequest::dataExpiry)).setter(CreateUploadJobRequest.setter(Builder::dataExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExpiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DISPLAY_NAME_FIELD, FIELDS_FIELD, UNIQUE_KEY_FIELD, DATA_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateUploadJobRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String displayName;
    private final Map<String, ObjectTypeField> fields;
    private final String uniqueKey;
    private final Integer dataExpiry;

    private CreateUploadJobRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.displayName = builder.displayName;
        this.fields = builder.fields;
        this.uniqueKey = builder.uniqueKey;
        this.dataExpiry = builder.dataExpiry;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, ObjectTypeField> fields() {
        return this.fields;
    }

    public final String uniqueKey() {
        return this.uniqueKey;
    }

    public final Integer dataExpiry() {
        return this.dataExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadJobRequest)) {
            return false;
        }
        CreateUploadJobRequest other = (CreateUploadJobRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.displayName(), other.displayName()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.uniqueKey(), other.uniqueKey()) && Objects.equals(this.dataExpiry(), other.dataExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUploadJobRequest").add("DomainName", (Object)this.domainName()).add("DisplayName", (Object)this.displayName()).add("Fields", (Object)(this.fields() == null ? null : "*** Sensitive Data Redacted ***")).add("UniqueKey", (Object)this.uniqueKey()).add("DataExpiry", (Object)this.dataExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "UniqueKey": {
                return Optional.ofNullable(clazz.cast(this.uniqueKey()));
            }
            case "DataExpiry": {
                return Optional.ofNullable(clazz.cast(this.dataExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Fields", FIELDS_FIELD);
        map.put("UniqueKey", UNIQUE_KEY_FIELD);
        map.put("DataExpiry", DATA_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUploadJobRequest, T> g) {
        return obj -> g.apply((CreateUploadJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String displayName;
        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();
        private String uniqueKey;
        private Integer dataExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadJobRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.displayName(model.displayName);
            this.fields(model.fields);
            this.uniqueKey(model.uniqueKey);
            this.dataExpiry(model.dataExpiry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final String getUniqueKey() {
            return this.uniqueKey;
        }

        public final void setUniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        @Override
        public final Builder uniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        public final Integer getDataExpiry() {
            return this.dataExpiry;
        }

        public final void setDataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
        }

        @Override
        public final Builder dataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUploadJobRequest build() {
            return new CreateUploadJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUploadJobRequest> {
        public Builder domainName(String var1);

        public Builder displayName(String var1);

        public Builder fields(Map<String, ObjectTypeField> var1);

        public Builder uniqueKey(String var1);

        public Builder dataExpiry(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

