/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactType {
    PHONE_NUMBER("PhoneNumber"),
    MOBILE_PHONE_NUMBER("MobilePhoneNumber"),
    HOME_PHONE_NUMBER("HomePhoneNumber"),
    BUSINESS_PHONE_NUMBER("BusinessPhoneNumber"),
    EMAIL_ADDRESS("EmailAddress"),
    PERSONAL_EMAIL_ADDRESS("PersonalEmailAddress"),
    BUSINESS_EMAIL_ADDRESS("BusinessEmailAddress"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactType> VALUE_MAP;
    private final String value;

    private ContactType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactType> knownValues() {
        EnumSet<ContactType> knownValues = EnumSet.allOf(ContactType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactType.class, ContactType::toString);
    }
}

