/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.AddressListCopier;
import software.amazon.awssdk.services.customerprofiles.model.AttributeMatchingModel;
import software.amazon.awssdk.services.customerprofiles.model.EmailListCopier;
import software.amazon.awssdk.services.customerprofiles.model.PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeTypesSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeTypesSelector> {
    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeMatchingModel").getter(AttributeTypesSelector.getter(AttributeTypesSelector::attributeMatchingModelAsString)).setter(AttributeTypesSelector.setter(Builder::attributeMatchingModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMatchingModel").build()}).build();
    private static final SdkField<List<String>> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Address").getter(AttributeTypesSelector.getter(AttributeTypesSelector::address)).setter(AttributeTypesSelector.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumber").getter(AttributeTypesSelector.getter(AttributeTypesSelector::phoneNumber)).setter(AttributeTypesSelector.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmailAddress").getter(AttributeTypesSelector.getter(AttributeTypesSelector::emailAddress)).setter(AttributeTypesSelector.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_MATCHING_MODEL_FIELD, ADDRESS_FIELD, PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeTypesSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeMatchingModel;
    private final List<String> address;
    private final List<String> phoneNumber;
    private final List<String> emailAddress;

    private AttributeTypesSelector(BuilderImpl builder) {
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.address = builder.address;
        this.phoneNumber = builder.phoneNumber;
        this.emailAddress = builder.emailAddress;
    }

    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(this.attributeMatchingModel);
    }

    public final String attributeMatchingModelAsString() {
        return this.attributeMatchingModel;
    }

    public final boolean hasAddress() {
        return this.address != null && !(this.address instanceof SdkAutoConstructList);
    }

    public final List<String> address() {
        return this.address;
    }

    public final boolean hasPhoneNumber() {
        return this.phoneNumber != null && !(this.phoneNumber instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumber() {
        return this.phoneNumber;
    }

    public final boolean hasEmailAddress() {
        return this.emailAddress != null && !(this.emailAddress instanceof SdkAutoConstructList);
    }

    public final List<String> emailAddress() {
        return this.emailAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddress() ? this.address() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumber() ? this.phoneNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmailAddress() ? this.emailAddress() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeTypesSelector)) {
            return false;
        }
        AttributeTypesSelector other = (AttributeTypesSelector)obj;
        return Objects.equals(this.attributeMatchingModelAsString(), other.attributeMatchingModelAsString()) && this.hasAddress() == other.hasAddress() && Objects.equals(this.address(), other.address()) && this.hasPhoneNumber() == other.hasPhoneNumber() && Objects.equals(this.phoneNumber(), other.phoneNumber()) && this.hasEmailAddress() == other.hasEmailAddress() && Objects.equals(this.emailAddress(), other.emailAddress());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeTypesSelector").add("AttributeMatchingModel", (Object)this.attributeMatchingModelAsString()).add("Address", this.hasAddress() ? this.address() : null).add("PhoneNumber", this.hasPhoneNumber() ? this.phoneNumber() : null).add("EmailAddress", this.hasEmailAddress() ? this.emailAddress() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeMatchingModel": {
                return Optional.ofNullable(clazz.cast(this.attributeMatchingModelAsString()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeMatchingModel", ATTRIBUTE_MATCHING_MODEL_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeTypesSelector, T> g) {
        return obj -> g.apply((AttributeTypesSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeMatchingModel;
        private List<String> address = DefaultSdkAutoConstructList.getInstance();
        private List<String> phoneNumber = DefaultSdkAutoConstructList.getInstance();
        private List<String> emailAddress = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeTypesSelector model) {
            this.attributeMatchingModel(model.attributeMatchingModel);
            this.address(model.address);
            this.phoneNumber(model.phoneNumber);
            this.emailAddress(model.emailAddress);
        }

        public final String getAttributeMatchingModel() {
            return this.attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final Collection<String> getAddress() {
            if (this.address instanceof SdkAutoConstructList) {
                return null;
            }
            return this.address;
        }

        public final void setAddress(Collection<String> address) {
            this.address = AddressListCopier.copy(address);
        }

        @Override
        public final Builder address(Collection<String> address) {
            this.address = AddressListCopier.copy(address);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder address(String ... address) {
            this.address(Arrays.asList(address));
            return this;
        }

        public final Collection<String> getPhoneNumber() {
            if (this.phoneNumber instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumber;
        }

        public final void setPhoneNumber(Collection<String> phoneNumber) {
            this.phoneNumber = PhoneNumberListCopier.copy(phoneNumber);
        }

        @Override
        public final Builder phoneNumber(Collection<String> phoneNumber) {
            this.phoneNumber = PhoneNumberListCopier.copy(phoneNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumber(String ... phoneNumber) {
            this.phoneNumber(Arrays.asList(phoneNumber));
            return this;
        }

        public final Collection<String> getEmailAddress() {
            if (this.emailAddress instanceof SdkAutoConstructList) {
                return null;
            }
            return this.emailAddress;
        }

        public final void setEmailAddress(Collection<String> emailAddress) {
            this.emailAddress = EmailListCopier.copy(emailAddress);
        }

        @Override
        public final Builder emailAddress(Collection<String> emailAddress) {
            this.emailAddress = EmailListCopier.copy(emailAddress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailAddress(String ... emailAddress) {
            this.emailAddress(Arrays.asList(emailAddress));
            return this;
        }

        public AttributeTypesSelector build() {
            return new AttributeTypesSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeTypesSelector> {
        public Builder attributeMatchingModel(String var1);

        public Builder attributeMatchingModel(AttributeMatchingModel var1);

        public Builder address(Collection<String> var1);

        public Builder address(String ... var1);

        public Builder phoneNumber(Collection<String> var1);

        public Builder phoneNumber(String ... var1);

        public Builder emailAddress(Collection<String> var1);

        public Builder emailAddress(String ... var1);
    }
}

