/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesResponse;

public class ListRuleBasedMatchesPublisher
implements SdkPublisher<ListRuleBasedMatchesResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListRuleBasedMatchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRuleBasedMatchesPublisher(CustomerProfilesAsyncClient client, ListRuleBasedMatchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRuleBasedMatchesPublisher(CustomerProfilesAsyncClient client, ListRuleBasedMatchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRuleBasedMatchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRuleBasedMatchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> matchIds() {
        Function<ListRuleBasedMatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.matchIds() != null) {
                return response.matchIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRuleBasedMatchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRuleBasedMatchesResponseFetcher
    implements AsyncPageFetcher<ListRuleBasedMatchesResponse> {
        private ListRuleBasedMatchesResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleBasedMatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRuleBasedMatchesResponse> nextPage(ListRuleBasedMatchesResponse previousPage) {
            if (previousPage == null) {
                return ListRuleBasedMatchesPublisher.this.client.listRuleBasedMatches(ListRuleBasedMatchesPublisher.this.firstRequest);
            }
            return ListRuleBasedMatchesPublisher.this.client.listRuleBasedMatches((ListRuleBasedMatchesRequest)((Object)ListRuleBasedMatchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

