/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.FilterDimension;
import software.amazon.awssdk.services.customerprofiles.model.FilterDimensionListCopier;
import software.amazon.awssdk.services.customerprofiles.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterGroup> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(FilterGroup.getter(FilterGroup::typeAsString)).setter(FilterGroup.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<FilterDimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(FilterGroup.getter(FilterGroup::dimensions)).setter(FilterGroup.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DIMENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<FilterDimension> dimensions;

    private FilterGroup(BuilderImpl builder) {
        this.type = builder.type;
        this.dimensions = builder.dimensions;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<FilterDimension> dimensions() {
        return this.dimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterGroup)) {
            return false;
        }
        FilterGroup other = (FilterGroup)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions());
    }

    public final String toString() {
        return ToString.builder((String)"FilterGroup").add("Type", (Object)this.typeAsString()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterGroup, T> g) {
        return obj -> g.apply((FilterGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<FilterDimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterGroup model) {
            this.type(model.type);
            this.dimensions(model.dimensions);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<FilterDimension.Builder> getDimensions() {
            List<FilterDimension.Builder> result = FilterDimensionListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<FilterDimension.BuilderImpl> dimensions) {
            this.dimensions = FilterDimensionListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<FilterDimension> dimensions) {
            this.dimensions = FilterDimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(FilterDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<FilterDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (FilterDimension)((FilterDimension.Builder)FilterDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FilterGroup build() {
            return new FilterGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterGroup> {
        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder dimensions(Collection<FilterDimension> var1);

        public Builder dimensions(FilterDimension ... var1);

        public Builder dimensions(Consumer<FilterDimension.Builder> ... var1);
    }
}

