/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.FieldNameListCopier;
import software.amazon.awssdk.services.customerprofiles.model.StandardIdentifier;
import software.amazon.awssdk.services.customerprofiles.model.StandardIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectTypeKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectTypeKey> {
    private static final SdkField<List<String>> STANDARD_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardIdentifiers").getter(ObjectTypeKey.getter(ObjectTypeKey::standardIdentifiersAsStrings)).setter(ObjectTypeKey.setter(Builder::standardIdentifiersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldNames").getter(ObjectTypeKey.getter(ObjectTypeKey::fieldNames)).setter(ObjectTypeKey.setter(Builder::fieldNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_IDENTIFIERS_FIELD, FIELD_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ObjectTypeKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> standardIdentifiers;
    private final List<String> fieldNames;

    private ObjectTypeKey(BuilderImpl builder) {
        this.standardIdentifiers = builder.standardIdentifiers;
        this.fieldNames = builder.fieldNames;
    }

    public final List<StandardIdentifier> standardIdentifiers() {
        return StandardIdentifierListCopier.copyStringToEnum(this.standardIdentifiers);
    }

    public final boolean hasStandardIdentifiers() {
        return this.standardIdentifiers != null && !(this.standardIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> standardIdentifiersAsStrings() {
        return this.standardIdentifiers;
    }

    public final boolean hasFieldNames() {
        return this.fieldNames != null && !(this.fieldNames instanceof SdkAutoConstructList);
    }

    public final List<String> fieldNames() {
        return this.fieldNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardIdentifiers() ? this.standardIdentifiersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldNames() ? this.fieldNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectTypeKey)) {
            return false;
        }
        ObjectTypeKey other = (ObjectTypeKey)obj;
        return this.hasStandardIdentifiers() == other.hasStandardIdentifiers() && Objects.equals(this.standardIdentifiersAsStrings(), other.standardIdentifiersAsStrings()) && this.hasFieldNames() == other.hasFieldNames() && Objects.equals(this.fieldNames(), other.fieldNames());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectTypeKey").add("StandardIdentifiers", this.hasStandardIdentifiers() ? this.standardIdentifiersAsStrings() : null).add("FieldNames", this.hasFieldNames() ? this.fieldNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.standardIdentifiersAsStrings()));
            }
            case "FieldNames": {
                return Optional.ofNullable(clazz.cast(this.fieldNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("StandardIdentifiers", STANDARD_IDENTIFIERS_FIELD);
        map.put("FieldNames", FIELD_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectTypeKey, T> g) {
        return obj -> g.apply((ObjectTypeKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> standardIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectTypeKey model) {
            this.standardIdentifiersWithStrings(model.standardIdentifiers);
            this.fieldNames(model.fieldNames);
        }

        public final Collection<String> getStandardIdentifiers() {
            if (this.standardIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.standardIdentifiers;
        }

        public final void setStandardIdentifiers(Collection<String> standardIdentifiers) {
            this.standardIdentifiers = StandardIdentifierListCopier.copy(standardIdentifiers);
        }

        @Override
        public final Builder standardIdentifiersWithStrings(Collection<String> standardIdentifiers) {
            this.standardIdentifiers = StandardIdentifierListCopier.copy(standardIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardIdentifiersWithStrings(String ... standardIdentifiers) {
            this.standardIdentifiersWithStrings(Arrays.asList(standardIdentifiers));
            return this;
        }

        @Override
        public final Builder standardIdentifiers(Collection<StandardIdentifier> standardIdentifiers) {
            this.standardIdentifiers = StandardIdentifierListCopier.copyEnumToString(standardIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardIdentifiers(StandardIdentifier ... standardIdentifiers) {
            this.standardIdentifiers(Arrays.asList(standardIdentifiers));
            return this;
        }

        public final Collection<String> getFieldNames() {
            if (this.fieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fieldNames;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String ... fieldNames) {
            this.fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public ObjectTypeKey build() {
            return new ObjectTypeKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectTypeKey> {
        public Builder standardIdentifiersWithStrings(Collection<String> var1);

        public Builder standardIdentifiersWithStrings(String ... var1);

        public Builder standardIdentifiers(Collection<StandardIdentifier> var1);

        public Builder standardIdentifiers(StandardIdentifier ... var1);

        public Builder fieldNames(Collection<String> var1);

        public Builder fieldNames(String ... var1);
    }
}

