/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.QOS;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class SubscribePacket {
    private List<Subscription> subscriptions;
    private Long subscriptionIdentifier;
    private List<UserProperty> userProperties;

    private SubscribePacket(SubscribePacketBuilder builder) {
        this.subscriptions = builder.subscriptions;
        this.subscriptionIdentifier = builder.subscriptionIdentifier;
        this.userProperties = builder.userProperties;
    }

    public static SubscribePacket of(String topicFilter, QOS qos) {
        Objects.requireNonNull(topicFilter, "topicFilter");
        Objects.requireNonNull(qos, "qos");
        return new SubscribePacketBuilder(topicFilter, qos).build();
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Long getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public static final class SubscribePacketBuilder {
        private List<Subscription> subscriptions = new ArrayList<Subscription>();
        Long subscriptionIdentifier;
        private List<UserProperty> userProperties;

        public SubscribePacketBuilder withSubscription(Subscription subscription) {
            this.subscriptions.add(subscription);
            return this;
        }

        public SubscribePacketBuilder withSubscription(String topicFilter, QOS qos, Boolean noLocal, Boolean retainAsPublished, RetainHandlingType retainHandlingType) {
            return this.withSubscription(new Subscription(topicFilter, qos, noLocal, retainAsPublished, retainHandlingType));
        }

        public SubscribePacketBuilder withSubscription(String topicFilter, QOS qos) {
            return this.withSubscription(new Subscription(topicFilter, qos));
        }

        public SubscribePacketBuilder withSubscriptionIdentifier(long subscriptionIdentifier) {
            this.subscriptionIdentifier = subscriptionIdentifier;
            return this;
        }

        public SubscribePacketBuilder withUserProperties(List<UserProperty> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public SubscribePacketBuilder() {
        }

        public SubscribePacketBuilder(Subscription subscription) {
            this.withSubscription(subscription);
        }

        public SubscribePacketBuilder(String topicFilter, QOS qos) {
            this.withSubscription(new Subscription(topicFilter, qos));
        }

        public SubscribePacket build() {
            return new SubscribePacket(this);
        }
    }

    public static final class Subscription {
        private String topicFilter;
        private QOS qos;
        private Boolean noLocal;
        private Boolean retainAsPublished;
        private RetainHandlingType retainHandlingType;

        Subscription(String topicFilter, QOS qos, Boolean noLocal, Boolean retainAsPublished, RetainHandlingType retainHandlingType) {
            this.topicFilter = topicFilter;
            this.qos = qos;
            this.noLocal = noLocal;
            this.retainAsPublished = retainAsPublished;
            this.retainHandlingType = retainHandlingType;
        }

        Subscription(String topicFilter, QOS qos) {
            this.topicFilter = topicFilter;
            this.qos = qos;
            this.noLocal = false;
            this.retainAsPublished = false;
            this.retainHandlingType = RetainHandlingType.SEND_ON_SUBSCRIBE;
        }

        public String getTopicFilter() {
            return this.topicFilter;
        }

        public QOS getQOS() {
            return this.qos;
        }

        public Boolean getNoLocal() {
            return this.noLocal;
        }

        public Boolean getRetainAsPublished() {
            return this.retainAsPublished;
        }

        public RetainHandlingType getRetainHandlingType() {
            return this.retainHandlingType;
        }
    }

    public static enum RetainHandlingType {
        SEND_ON_SUBSCRIBE(0),
        SEND_ON_SUBSCRIBE_IF_NEW(1),
        DONT_SEND(2);

        private int type;
        private static Map<Integer, RetainHandlingType> enumMapping;

        private RetainHandlingType(int code) {
            this.type = code;
        }

        public int getValue() {
            return this.type;
        }

        public static RetainHandlingType getEnumValueFromInteger(int value) {
            RetainHandlingType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal RetainHandlingType");
        }

        private static Map<Integer, RetainHandlingType> buildEnumMapping() {
            return Stream.of(RetainHandlingType.values()).collect(Collectors.toMap(RetainHandlingType::getValue, Function.identity()));
        }

        static {
            enumMapping = RetainHandlingType.buildEnumMapping();
        }
    }
}

