/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.ByteBuffer;
import java.util.List;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.eventstream.Header;

public class Message
extends CrtResource {
    public Message(List<Header> headers, byte[] payload) {
        this.acquireNativeHandle(Message.messageNew(Header.marshallHeadersForJNI(headers), payload));
    }

    public ByteBuffer getMessageBuffer() {
        return Message.messageBuffer(this.getNativeHandle());
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            Message.messageDelete(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native long messageNew(byte[] var0, byte[] var1);

    private static native void messageDelete(long var0);

    private static native ByteBuffer messageBuffer(long var0);
}

