/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlushCallback;
import software.amazon.awssdk.crt.eventstream.MessageType;

public class ServerConnectionContinuation
extends CrtResource {
    ServerConnectionContinuation(long continuationPtr) {
        ServerConnectionContinuation.acquire(continuationPtr);
        this.acquireNativeHandle(continuationPtr);
    }

    public boolean isClosed() {
        return ServerConnectionContinuation.isClosed(this.getNativeHandle());
    }

    public CompletableFuture<Void> sendMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags) {
        CompletableFuture<Void> messageFlush = new CompletableFuture<Void>();
        this.sendMessage(headers, payload, messageType, messageFlags, errorCode -> {
            if (errorCode == 0) {
                messageFlush.complete(null);
            } else {
                messageFlush.completeExceptionally(new CrtRuntimeException(errorCode));
            }
        });
        return messageFlush;
    }

    public void sendMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags, MessageFlushCallback callback) {
        byte[] headersBuf = headers != null ? Header.marshallHeadersForJNI(headers) : null;
        int result = ServerConnectionContinuation.sendContinuationMessage(this.getNativeHandle(), headersBuf, payload, messageType.getEnumValue(), messageFlags, callback);
        if (result != 0) {
            int errorCode = CRT.awsLastError();
            throw new CrtRuntimeException(errorCode);
        }
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ServerConnectionContinuation.release(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native void acquire(long var0);

    private static native void release(long var0);

    private static native boolean isClosed(long var0);

    private static native int sendContinuationMessage(long var0, byte[] var2, byte[] var3, int var4, int var5, MessageFlushCallback var6);
}

