/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.EfficiencyMetricsByGroup;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEfficiencyMetricsRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEfficiencyMetricsResponse;

public class ListEfficiencyMetricsIterable
implements SdkIterable<ListEfficiencyMetricsResponse> {
    private final CostOptimizationHubClient client;
    private final ListEfficiencyMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEfficiencyMetricsIterable(CostOptimizationHubClient client, ListEfficiencyMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEfficiencyMetricsResponseFetcher();
    }

    public Iterator<ListEfficiencyMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EfficiencyMetricsByGroup> efficiencyMetricsByGroup() {
        Function<ListEfficiencyMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.efficiencyMetricsByGroup() != null) {
                return response.efficiencyMetricsByGroup().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEfficiencyMetricsResponseFetcher
    implements SyncPageFetcher<ListEfficiencyMetricsResponse> {
        private ListEfficiencyMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListEfficiencyMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEfficiencyMetricsResponse nextPage(ListEfficiencyMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListEfficiencyMetricsIterable.this.client.listEfficiencyMetrics(ListEfficiencyMetricsIterable.this.firstRequest);
            }
            return ListEfficiencyMetricsIterable.this.client.listEfficiencyMetrics((ListEfficiencyMetricsRequest)((Object)ListEfficiencyMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

