/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubAsyncClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse;

public class ListEnrollmentStatusesPublisher
implements SdkPublisher<ListEnrollmentStatusesResponse> {
    private final CostOptimizationHubAsyncClient client;
    private final ListEnrollmentStatusesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnrollmentStatusesPublisher(CostOptimizationHubAsyncClient client, ListEnrollmentStatusesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnrollmentStatusesPublisher(CostOptimizationHubAsyncClient client, ListEnrollmentStatusesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnrollmentStatusesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnrollmentStatusesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountEnrollmentStatus> items() {
        Function<ListEnrollmentStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnrollmentStatusesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnrollmentStatusesResponseFetcher
    implements AsyncPageFetcher<ListEnrollmentStatusesResponse> {
        private ListEnrollmentStatusesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnrollmentStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnrollmentStatusesResponse> nextPage(ListEnrollmentStatusesResponse previousPage) {
            if (previousPage == null) {
                return ListEnrollmentStatusesPublisher.this.client.listEnrollmentStatuses(ListEnrollmentStatusesPublisher.this.firstRequest);
            }
            return ListEnrollmentStatusesPublisher.this.client.listEnrollmentStatuses((ListEnrollmentStatusesRequest)((Object)ListEnrollmentStatusesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

