/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImplementationEffort {
    VERY_LOW("VeryLow"),
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High"),
    VERY_HIGH("VeryHigh"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImplementationEffort> VALUE_MAP;
    private final String value;

    private ImplementationEffort(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImplementationEffort fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImplementationEffort> knownValues() {
        EnumSet<ImplementationEffort> knownValues = EnumSet.allOf(ImplementationEffort.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImplementationEffort.class, ImplementationEffort::toString);
    }
}

