/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SummaryMetrics {
    SAVINGS_PERCENTAGE("SavingsPercentage"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SummaryMetrics> VALUE_MAP;
    private final String value;

    private SummaryMetrics(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SummaryMetrics fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SummaryMetrics> knownValues() {
        EnumSet<SummaryMetrics> knownValues = EnumSet.allOf(SummaryMetrics.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SummaryMetrics.class, SummaryMetrics::toString);
    }
}

