/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.PlatformDifference;
import software.amazon.awssdk.services.costexplorer.model.PlatformDifferencesCopier;
import software.amazon.awssdk.services.costexplorer.model.ResourceDetails;
import software.amazon.awssdk.services.costexplorer.model.ResourceUtilization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetInstance> {
    private static final SdkField<String> ESTIMATED_MONTHLY_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlyCost").getter(TargetInstance.getter(TargetInstance::estimatedMonthlyCost)).setter(TargetInstance.setter(Builder::estimatedMonthlyCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlyCost").build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlySavings").getter(TargetInstance.getter(TargetInstance::estimatedMonthlySavings)).setter(TargetInstance.setter(Builder::estimatedMonthlySavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavings").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(TargetInstance.getter(TargetInstance::currencyCode)).setter(TargetInstance.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Boolean> DEFAULT_TARGET_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultTargetInstance").getter(TargetInstance.getter(TargetInstance::defaultTargetInstance)).setter(TargetInstance.setter(Builder::defaultTargetInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTargetInstance").build()}).build();
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(TargetInstance.getter(TargetInstance::resourceDetails)).setter(TargetInstance.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()}).build();
    private static final SdkField<ResourceUtilization> EXPECTED_RESOURCE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpectedResourceUtilization").getter(TargetInstance.getter(TargetInstance::expectedResourceUtilization)).setter(TargetInstance.setter(Builder::expectedResourceUtilization)).constructor(ResourceUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedResourceUtilization").build()}).build();
    private static final SdkField<List<String>> PLATFORM_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlatformDifferences").getter(TargetInstance.getter(TargetInstance::platformDifferencesAsStrings)).setter(TargetInstance.setter(Builder::platformDifferencesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDifferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_MONTHLY_COST_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD, CURRENCY_CODE_FIELD, DEFAULT_TARGET_INSTANCE_FIELD, RESOURCE_DETAILS_FIELD, EXPECTED_RESOURCE_UTILIZATION_FIELD, PLATFORM_DIFFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String estimatedMonthlyCost;
    private final String estimatedMonthlySavings;
    private final String currencyCode;
    private final Boolean defaultTargetInstance;
    private final ResourceDetails resourceDetails;
    private final ResourceUtilization expectedResourceUtilization;
    private final List<String> platformDifferences;

    private TargetInstance(BuilderImpl builder) {
        this.estimatedMonthlyCost = builder.estimatedMonthlyCost;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.currencyCode = builder.currencyCode;
        this.defaultTargetInstance = builder.defaultTargetInstance;
        this.resourceDetails = builder.resourceDetails;
        this.expectedResourceUtilization = builder.expectedResourceUtilization;
        this.platformDifferences = builder.platformDifferences;
    }

    public final String estimatedMonthlyCost() {
        return this.estimatedMonthlyCost;
    }

    public final String estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Boolean defaultTargetInstance() {
        return this.defaultTargetInstance;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final ResourceUtilization expectedResourceUtilization() {
        return this.expectedResourceUtilization;
    }

    public final List<PlatformDifference> platformDifferences() {
        return PlatformDifferencesCopier.copyStringToEnum(this.platformDifferences);
    }

    public final boolean hasPlatformDifferences() {
        return this.platformDifferences != null && !(this.platformDifferences instanceof SdkAutoConstructList);
    }

    public final List<String> platformDifferencesAsStrings() {
        return this.platformDifferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTargetInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedResourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformDifferences() ? this.platformDifferencesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstance)) {
            return false;
        }
        TargetInstance other = (TargetInstance)obj;
        return Objects.equals(this.estimatedMonthlyCost(), other.estimatedMonthlyCost()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.defaultTargetInstance(), other.defaultTargetInstance()) && Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.expectedResourceUtilization(), other.expectedResourceUtilization()) && this.hasPlatformDifferences() == other.hasPlatformDifferences() && Objects.equals(this.platformDifferencesAsStrings(), other.platformDifferencesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TargetInstance").add("EstimatedMonthlyCost", (Object)this.estimatedMonthlyCost()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).add("CurrencyCode", (Object)this.currencyCode()).add("DefaultTargetInstance", (Object)this.defaultTargetInstance()).add("ResourceDetails", (Object)this.resourceDetails()).add("ExpectedResourceUtilization", (Object)this.expectedResourceUtilization()).add("PlatformDifferences", this.hasPlatformDifferences() ? this.platformDifferencesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EstimatedMonthlyCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlyCost()));
            }
            case "EstimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "DefaultTargetInstance": {
                return Optional.ofNullable(clazz.cast(this.defaultTargetInstance()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "ExpectedResourceUtilization": {
                return Optional.ofNullable(clazz.cast(this.expectedResourceUtilization()));
            }
            case "PlatformDifferences": {
                return Optional.ofNullable(clazz.cast(this.platformDifferencesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EstimatedMonthlyCost", ESTIMATED_MONTHLY_COST_FIELD);
        map.put("EstimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("DefaultTargetInstance", DEFAULT_TARGET_INSTANCE_FIELD);
        map.put("ResourceDetails", RESOURCE_DETAILS_FIELD);
        map.put("ExpectedResourceUtilization", EXPECTED_RESOURCE_UTILIZATION_FIELD);
        map.put("PlatformDifferences", PLATFORM_DIFFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetInstance, T> g) {
        return obj -> g.apply((TargetInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String estimatedMonthlyCost;
        private String estimatedMonthlySavings;
        private String currencyCode;
        private Boolean defaultTargetInstance;
        private ResourceDetails resourceDetails;
        private ResourceUtilization expectedResourceUtilization;
        private List<String> platformDifferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstance model) {
            this.estimatedMonthlyCost(model.estimatedMonthlyCost);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
            this.currencyCode(model.currencyCode);
            this.defaultTargetInstance(model.defaultTargetInstance);
            this.resourceDetails(model.resourceDetails);
            this.expectedResourceUtilization(model.expectedResourceUtilization);
            this.platformDifferencesWithStrings(model.platformDifferences);
        }

        public final String getEstimatedMonthlyCost() {
            return this.estimatedMonthlyCost;
        }

        public final void setEstimatedMonthlyCost(String estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
        }

        @Override
        public final Builder estimatedMonthlyCost(String estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
            return this;
        }

        public final String getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Boolean getDefaultTargetInstance() {
            return this.defaultTargetInstance;
        }

        public final void setDefaultTargetInstance(Boolean defaultTargetInstance) {
            this.defaultTargetInstance = defaultTargetInstance;
        }

        @Override
        public final Builder defaultTargetInstance(Boolean defaultTargetInstance) {
            this.defaultTargetInstance = defaultTargetInstance;
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final ResourceUtilization.Builder getExpectedResourceUtilization() {
            return this.expectedResourceUtilization != null ? this.expectedResourceUtilization.toBuilder() : null;
        }

        public final void setExpectedResourceUtilization(ResourceUtilization.BuilderImpl expectedResourceUtilization) {
            this.expectedResourceUtilization = expectedResourceUtilization != null ? expectedResourceUtilization.build() : null;
        }

        @Override
        public final Builder expectedResourceUtilization(ResourceUtilization expectedResourceUtilization) {
            this.expectedResourceUtilization = expectedResourceUtilization;
            return this;
        }

        public final Collection<String> getPlatformDifferences() {
            if (this.platformDifferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformDifferences;
        }

        public final void setPlatformDifferences(Collection<String> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copy(platformDifferences);
        }

        @Override
        public final Builder platformDifferencesWithStrings(Collection<String> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copy(platformDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDifferencesWithStrings(String ... platformDifferences) {
            this.platformDifferencesWithStrings(Arrays.asList(platformDifferences));
            return this;
        }

        @Override
        public final Builder platformDifferences(Collection<PlatformDifference> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copyEnumToString(platformDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDifferences(PlatformDifference ... platformDifferences) {
            this.platformDifferences(Arrays.asList(platformDifferences));
            return this;
        }

        public TargetInstance build() {
            return new TargetInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetInstance> {
        public Builder estimatedMonthlyCost(String var1);

        public Builder estimatedMonthlySavings(String var1);

        public Builder currencyCode(String var1);

        public Builder defaultTargetInstance(Boolean var1);

        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder expectedResourceUtilization(ResourceUtilization var1);

        default public Builder expectedResourceUtilization(Consumer<ResourceUtilization.Builder> expectedResourceUtilization) {
            return this.expectedResourceUtilization((ResourceUtilization)((ResourceUtilization.Builder)ResourceUtilization.builder().applyMutation(expectedResourceUtilization)).build());
        }

        public Builder platformDifferencesWithStrings(Collection<String> var1);

        public Builder platformDifferencesWithStrings(String ... var1);

        public Builder platformDifferences(Collection<PlatformDifference> var1);

        public Builder platformDifferences(PlatformDifference ... var1);
    }
}

