/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostComparisonDriver;
import software.amazon.awssdk.services.costexplorer.model.CostComparisonDriversCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostComparisonDriversResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetCostComparisonDriversResponse> {
    private static final SdkField<List<CostComparisonDriver>> COST_COMPARISON_DRIVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostComparisonDrivers").getter(GetCostComparisonDriversResponse.getter(GetCostComparisonDriversResponse::costComparisonDrivers)).setter(GetCostComparisonDriversResponse.setter(Builder::costComparisonDrivers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostComparisonDrivers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostComparisonDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetCostComparisonDriversResponse.getter(GetCostComparisonDriversResponse::nextPageToken)).setter(GetCostComparisonDriversResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_COMPARISON_DRIVERS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCostComparisonDriversResponse.memberNameToFieldInitializer();
    private final List<CostComparisonDriver> costComparisonDrivers;
    private final String nextPageToken;

    private GetCostComparisonDriversResponse(BuilderImpl builder) {
        super(builder);
        this.costComparisonDrivers = builder.costComparisonDrivers;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasCostComparisonDrivers() {
        return this.costComparisonDrivers != null && !(this.costComparisonDrivers instanceof SdkAutoConstructList);
    }

    public final List<CostComparisonDriver> costComparisonDrivers() {
        return this.costComparisonDrivers;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostComparisonDrivers() ? this.costComparisonDrivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostComparisonDriversResponse)) {
            return false;
        }
        GetCostComparisonDriversResponse other = (GetCostComparisonDriversResponse)((Object)obj);
        return this.hasCostComparisonDrivers() == other.hasCostComparisonDrivers() && Objects.equals(this.costComparisonDrivers(), other.costComparisonDrivers()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostComparisonDriversResponse").add("CostComparisonDrivers", this.hasCostComparisonDrivers() ? this.costComparisonDrivers() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostComparisonDrivers": {
                return Optional.ofNullable(clazz.cast(this.costComparisonDrivers()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CostComparisonDrivers", COST_COMPARISON_DRIVERS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostComparisonDriversResponse, T> g) {
        return obj -> g.apply((GetCostComparisonDriversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<CostComparisonDriver> costComparisonDrivers = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostComparisonDriversResponse model) {
            super(model);
            this.costComparisonDrivers(model.costComparisonDrivers);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<CostComparisonDriver.Builder> getCostComparisonDrivers() {
            List<CostComparisonDriver.Builder> result = CostComparisonDriversCopier.copyToBuilder(this.costComparisonDrivers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostComparisonDrivers(Collection<CostComparisonDriver.BuilderImpl> costComparisonDrivers) {
            this.costComparisonDrivers = CostComparisonDriversCopier.copyFromBuilder(costComparisonDrivers);
        }

        @Override
        public final Builder costComparisonDrivers(Collection<CostComparisonDriver> costComparisonDrivers) {
            this.costComparisonDrivers = CostComparisonDriversCopier.copy(costComparisonDrivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costComparisonDrivers(CostComparisonDriver ... costComparisonDrivers) {
            this.costComparisonDrivers(Arrays.asList(costComparisonDrivers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costComparisonDrivers(Consumer<CostComparisonDriver.Builder> ... costComparisonDrivers) {
            this.costComparisonDrivers(Stream.of(costComparisonDrivers).map(c -> (CostComparisonDriver)((CostComparisonDriver.Builder)CostComparisonDriver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetCostComparisonDriversResponse build() {
            return new GetCostComparisonDriversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostComparisonDriversResponse> {
        public Builder costComparisonDrivers(Collection<CostComparisonDriver> var1);

        public Builder costComparisonDrivers(CostComparisonDriver ... var1);

        public Builder costComparisonDrivers(Consumer<CostComparisonDriver.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

