/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.ComparisonMetricValue;
import software.amazon.awssdk.services.costexplorer.model.ComparisonMetricsCopier;
import software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison;
import software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparisonsCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostAndUsageComparisonsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetCostAndUsageComparisonsResponse> {
    private static final SdkField<List<CostAndUsageComparison>> COST_AND_USAGE_COMPARISONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostAndUsageComparisons").getter(GetCostAndUsageComparisonsResponse.getter(GetCostAndUsageComparisonsResponse::costAndUsageComparisons)).setter(GetCostAndUsageComparisonsResponse.setter(Builder::costAndUsageComparisons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostAndUsageComparisons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostAndUsageComparison::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComparisonMetricValue>> TOTAL_COST_AND_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TotalCostAndUsage").getter(GetCostAndUsageComparisonsResponse.getter(GetCostAndUsageComparisonsResponse::totalCostAndUsage)).setter(GetCostAndUsageComparisonsResponse.setter(Builder::totalCostAndUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCostAndUsage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComparisonMetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetCostAndUsageComparisonsResponse.getter(GetCostAndUsageComparisonsResponse::nextPageToken)).setter(GetCostAndUsageComparisonsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_AND_USAGE_COMPARISONS_FIELD, TOTAL_COST_AND_USAGE_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCostAndUsageComparisonsResponse.memberNameToFieldInitializer();
    private final List<CostAndUsageComparison> costAndUsageComparisons;
    private final Map<String, ComparisonMetricValue> totalCostAndUsage;
    private final String nextPageToken;

    private GetCostAndUsageComparisonsResponse(BuilderImpl builder) {
        super(builder);
        this.costAndUsageComparisons = builder.costAndUsageComparisons;
        this.totalCostAndUsage = builder.totalCostAndUsage;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasCostAndUsageComparisons() {
        return this.costAndUsageComparisons != null && !(this.costAndUsageComparisons instanceof SdkAutoConstructList);
    }

    public final List<CostAndUsageComparison> costAndUsageComparisons() {
        return this.costAndUsageComparisons;
    }

    public final boolean hasTotalCostAndUsage() {
        return this.totalCostAndUsage != null && !(this.totalCostAndUsage instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComparisonMetricValue> totalCostAndUsage() {
        return this.totalCostAndUsage;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostAndUsageComparisons() ? this.costAndUsageComparisons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTotalCostAndUsage() ? this.totalCostAndUsage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageComparisonsResponse)) {
            return false;
        }
        GetCostAndUsageComparisonsResponse other = (GetCostAndUsageComparisonsResponse)((Object)obj);
        return this.hasCostAndUsageComparisons() == other.hasCostAndUsageComparisons() && Objects.equals(this.costAndUsageComparisons(), other.costAndUsageComparisons()) && this.hasTotalCostAndUsage() == other.hasTotalCostAndUsage() && Objects.equals(this.totalCostAndUsage(), other.totalCostAndUsage()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostAndUsageComparisonsResponse").add("CostAndUsageComparisons", this.hasCostAndUsageComparisons() ? this.costAndUsageComparisons() : null).add("TotalCostAndUsage", this.hasTotalCostAndUsage() ? this.totalCostAndUsage() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostAndUsageComparisons": {
                return Optional.ofNullable(clazz.cast(this.costAndUsageComparisons()));
            }
            case "TotalCostAndUsage": {
                return Optional.ofNullable(clazz.cast(this.totalCostAndUsage()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CostAndUsageComparisons", COST_AND_USAGE_COMPARISONS_FIELD);
        map.put("TotalCostAndUsage", TOTAL_COST_AND_USAGE_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostAndUsageComparisonsResponse, T> g) {
        return obj -> g.apply((GetCostAndUsageComparisonsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<CostAndUsageComparison> costAndUsageComparisons = DefaultSdkAutoConstructList.getInstance();
        private Map<String, ComparisonMetricValue> totalCostAndUsage = DefaultSdkAutoConstructMap.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageComparisonsResponse model) {
            super(model);
            this.costAndUsageComparisons(model.costAndUsageComparisons);
            this.totalCostAndUsage(model.totalCostAndUsage);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<CostAndUsageComparison.Builder> getCostAndUsageComparisons() {
            List<CostAndUsageComparison.Builder> result = CostAndUsageComparisonsCopier.copyToBuilder(this.costAndUsageComparisons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostAndUsageComparisons(Collection<CostAndUsageComparison.BuilderImpl> costAndUsageComparisons) {
            this.costAndUsageComparisons = CostAndUsageComparisonsCopier.copyFromBuilder(costAndUsageComparisons);
        }

        @Override
        public final Builder costAndUsageComparisons(Collection<CostAndUsageComparison> costAndUsageComparisons) {
            this.costAndUsageComparisons = CostAndUsageComparisonsCopier.copy(costAndUsageComparisons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAndUsageComparisons(CostAndUsageComparison ... costAndUsageComparisons) {
            this.costAndUsageComparisons(Arrays.asList(costAndUsageComparisons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAndUsageComparisons(Consumer<CostAndUsageComparison.Builder> ... costAndUsageComparisons) {
            this.costAndUsageComparisons(Stream.of(costAndUsageComparisons).map(c -> (CostAndUsageComparison)((CostAndUsageComparison.Builder)CostAndUsageComparison.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ComparisonMetricValue.Builder> getTotalCostAndUsage() {
            Map<String, ComparisonMetricValue.Builder> result = ComparisonMetricsCopier.copyToBuilder(this.totalCostAndUsage);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTotalCostAndUsage(Map<String, ComparisonMetricValue.BuilderImpl> totalCostAndUsage) {
            this.totalCostAndUsage = ComparisonMetricsCopier.copyFromBuilder(totalCostAndUsage);
        }

        @Override
        public final Builder totalCostAndUsage(Map<String, ComparisonMetricValue> totalCostAndUsage) {
            this.totalCostAndUsage = ComparisonMetricsCopier.copy(totalCostAndUsage);
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetCostAndUsageComparisonsResponse build() {
            return new GetCostAndUsageComparisonsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostAndUsageComparisonsResponse> {
        public Builder costAndUsageComparisons(Collection<CostAndUsageComparison> var1);

        public Builder costAndUsageComparisons(CostAndUsageComparison ... var1);

        public Builder costAndUsageComparisons(Consumer<CostAndUsageComparison.Builder> ... var1);

        public Builder totalCostAndUsage(Map<String, ComparisonMetricValue> var1);

        public Builder nextPageToken(String var1);
    }
}

