/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.ComparisonMetricValue;
import software.amazon.awssdk.services.costexplorer.model.ComparisonMetricsCopier;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostAndUsageComparison
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostAndUsageComparison> {
    private static final SdkField<Expression> COST_AND_USAGE_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CostAndUsageSelector").getter(CostAndUsageComparison.getter(CostAndUsageComparison::costAndUsageSelector)).setter(CostAndUsageComparison.setter(Builder::costAndUsageSelector)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostAndUsageSelector").build()}).build();
    private static final SdkField<Map<String, ComparisonMetricValue>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(CostAndUsageComparison.getter(CostAndUsageComparison::metrics)).setter(CostAndUsageComparison.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComparisonMetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_AND_USAGE_SELECTOR_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CostAndUsageComparison.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Expression costAndUsageSelector;
    private final Map<String, ComparisonMetricValue> metrics;

    private CostAndUsageComparison(BuilderImpl builder) {
        this.costAndUsageSelector = builder.costAndUsageSelector;
        this.metrics = builder.metrics;
    }

    public final Expression costAndUsageSelector() {
        return this.costAndUsageSelector;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComparisonMetricValue> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costAndUsageSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostAndUsageComparison)) {
            return false;
        }
        CostAndUsageComparison other = (CostAndUsageComparison)obj;
        return Objects.equals(this.costAndUsageSelector(), other.costAndUsageSelector()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics());
    }

    public final String toString() {
        return ToString.builder((String)"CostAndUsageComparison").add("CostAndUsageSelector", (Object)this.costAndUsageSelector()).add("Metrics", this.hasMetrics() ? this.metrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostAndUsageSelector": {
                return Optional.ofNullable(clazz.cast(this.costAndUsageSelector()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CostAndUsageSelector", COST_AND_USAGE_SELECTOR_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostAndUsageComparison, T> g) {
        return obj -> g.apply((CostAndUsageComparison)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Expression costAndUsageSelector;
        private Map<String, ComparisonMetricValue> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostAndUsageComparison model) {
            this.costAndUsageSelector(model.costAndUsageSelector);
            this.metrics(model.metrics);
        }

        public final Expression.Builder getCostAndUsageSelector() {
            return this.costAndUsageSelector != null ? this.costAndUsageSelector.toBuilder() : null;
        }

        public final void setCostAndUsageSelector(Expression.BuilderImpl costAndUsageSelector) {
            this.costAndUsageSelector = costAndUsageSelector != null ? costAndUsageSelector.build() : null;
        }

        @Override
        public final Builder costAndUsageSelector(Expression costAndUsageSelector) {
            this.costAndUsageSelector = costAndUsageSelector;
            return this;
        }

        public final Map<String, ComparisonMetricValue.Builder> getMetrics() {
            Map<String, ComparisonMetricValue.Builder> result = ComparisonMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Map<String, ComparisonMetricValue.BuilderImpl> metrics) {
            this.metrics = ComparisonMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Map<String, ComparisonMetricValue> metrics) {
            this.metrics = ComparisonMetricsCopier.copy(metrics);
            return this;
        }

        public CostAndUsageComparison build() {
            return new CostAndUsageComparison(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostAndUsageComparison> {
        public Builder costAndUsageSelector(Expression var1);

        default public Builder costAndUsageSelector(Consumer<Expression.Builder> costAndUsageSelector) {
            return this.costAndUsageSelector((Expression)((Expression.Builder)Expression.builder().applyMutation(costAndUsageSelector)).build());
        }

        public Builder metrics(Map<String, ComparisonMetricValue> var1);
    }
}

