/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;

public class GetAnomalyMonitorsPublisher
implements SdkPublisher<GetAnomalyMonitorsResponse> {
    private final CostExplorerAsyncClient client;
    private final GetAnomalyMonitorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAnomalyMonitorsPublisher(CostExplorerAsyncClient client, GetAnomalyMonitorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAnomalyMonitorsPublisher(CostExplorerAsyncClient client, GetAnomalyMonitorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAnomalyMonitorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAnomalyMonitorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnomalyMonitor> anomalyMonitors() {
        Function<GetAnomalyMonitorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyMonitors() != null) {
                return response.anomalyMonitors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAnomalyMonitorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAnomalyMonitorsResponseFetcher
    implements AsyncPageFetcher<GetAnomalyMonitorsResponse> {
        private GetAnomalyMonitorsResponseFetcher() {
        }

        public boolean hasNextPage(GetAnomalyMonitorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetAnomalyMonitorsResponse> nextPage(GetAnomalyMonitorsResponse previousPage) {
            if (previousPage == null) {
                return GetAnomalyMonitorsPublisher.this.client.getAnomalyMonitors(GetAnomalyMonitorsPublisher.this.firstRequest);
            }
            return GetAnomalyMonitorsPublisher.this.client.getAnomalyMonitors((GetAnomalyMonitorsRequest)((Object)GetAnomalyMonitorsPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

