/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OfferingClass {
    STANDARD("STANDARD"),
    CONVERTIBLE("CONVERTIBLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OfferingClass> VALUE_MAP;
    private final String value;

    private OfferingClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OfferingClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OfferingClass> knownValues() {
        EnumSet<OfferingClass> knownValues = EnumSet.allOf(OfferingClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OfferingClass.class, OfferingClass::toString);
    }
}

